/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.internal;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;
import org.javamoney.moneta.ExchangeRateBuilder;
import org.javamoney.moneta.convert.internal.ECBHistoricRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class RateReadingHandler
extends DefaultHandler {
    private LocalDate localDate;
    private final Map<LocalDate, Map<String, ExchangeRate>> historicRates;
    private ProviderContext context;

    public RateReadingHandler(Map<LocalDate, Map<String, ExchangeRate>> historicRates, ProviderContext context) {
        this.historicRates = historicRates;
        this.context = context;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("Cube".equals(qName)) {
            if (Objects.nonNull(attributes.getValue("time"))) {
                this.localDate = LocalDate.parse(attributes.getValue("time")).atStartOfDay().toLocalDate();
            } else if (Objects.nonNull(attributes.getValue("currency"))) {
                CurrencyUnit tgtCurrency = MonetaryCurrencies.getCurrency((String)attributes.getValue("currency"), (String[])new String[0]);
                this.addRate(tgtCurrency, this.localDate, BigDecimal.valueOf(Double.parseDouble(attributes.getValue("rate"))));
            }
        }
        super.startElement(uri, localName, qName, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRate(CurrencyUnit term, LocalDate localDate, Number rate) {
        ExchangeRateBuilder builder;
        RateType rateType = RateType.HISTORIC;
        if (Objects.nonNull(localDate)) {
            if (localDate.equals(LocalDate.now())) {
                rateType = RateType.DEFERRED;
            }
            builder = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)this.context, (RateType)rateType).set((Object)localDate)).build());
        } else {
            builder = new ExchangeRateBuilder(ConversionContextBuilder.create((ProviderContext)this.context, (RateType)rateType).build());
        }
        builder.setBase(ECBHistoricRateProvider.BASE_CURRENCY);
        builder.setTerm(term);
        builder.setFactor(DefaultNumberValue.of(rate));
        ExchangeRate exchangeRate = builder.build();
        Map rateMap = this.historicRates.get(localDate);
        if (Objects.isNull(rateMap)) {
            Map<LocalDate, Map<String, ExchangeRate>> map = this.historicRates;
            synchronized (map) {
                rateMap = Optional.ofNullable(this.historicRates.get(localDate)).orElse(new ConcurrentHashMap());
                this.historicRates.putIfAbsent(localDate, rateMap);
            }
        }
        rateMap.put((String)term.getCurrencyCode(), (ExchangeRate)exchangeRate);
    }
}

