/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRateProvider;
import org.javamoney.moneta.function.DefaultMonetarySummaryStatistics;
import org.javamoney.moneta.function.MonetarySummaryStatistics;

class ExchangeRateMonetarySummaryStatistics
extends DefaultMonetarySummaryStatistics {
    private ExchangeRateProvider provider;
    private CurrencyConversion currencyConversion;

    ExchangeRateMonetarySummaryStatistics(CurrencyUnit currencyUnit, ExchangeRateProvider provider) {
        super(currencyUnit);
        this.provider = provider;
        this.currencyConversion = provider.getCurrencyConversion(this.getCurrencyUnit());
    }

    @Override
    public void accept(MonetaryAmount amount) {
        super.accept((MonetaryAmount)this.currencyConversion.apply((Object)amount));
    }

    @Override
    public MonetarySummaryStatistics combine(MonetarySummaryStatistics summaryStatistics) {
        if (this.isDifferentCurrency(Objects.requireNonNull(summaryStatistics).getCurrencyUnit())) {
            return super.combine(this.convert(summaryStatistics));
        }
        return super.combine(summaryStatistics);
    }

    private MonetarySummaryStatistics convert(MonetarySummaryStatistics summaryStatistics) {
        if (summaryStatistics.isExchangeable()) {
            return summaryStatistics.to(this.getCurrencyUnit());
        }
        return this.create(summaryStatistics);
    }

    private MonetarySummaryStatistics create(MonetarySummaryStatistics summary) {
        ExchangeRateMonetarySummaryStatistics another = new ExchangeRateMonetarySummaryStatistics(this.getCurrencyUnit(), this.provider);
        another.average = (MonetaryAmount)this.currencyConversion.apply((Object)summary.getAverage());
        another.count = summary.getCount();
        another.max = (MonetaryAmount)this.currencyConversion.apply((Object)summary.getMax());
        another.min = (MonetaryAmount)this.currencyConversion.apply((Object)summary.getMin());
        another.sum = (MonetaryAmount)this.currencyConversion.apply((Object)summary.getSum());
        return another;
    }

    private boolean isDifferentCurrency(CurrencyUnit unit) {
        return !this.getCurrencyUnit().equals(unit);
    }

    @Override
    public boolean isExchangeable() {
        return true;
    }

    @Override
    public MonetarySummaryStatistics to(CurrencyUnit unit) {
        CurrencyConversion currencyConversion = this.provider.getCurrencyConversion(unit);
        ExchangeRateMonetarySummaryStatistics another = new ExchangeRateMonetarySummaryStatistics(unit, this.provider);
        another.average = (MonetaryAmount)currencyConversion.apply((Object)this.average);
        another.count = this.count;
        another.max = (MonetaryAmount)currencyConversion.apply((Object)this.max);
        another.min = (MonetaryAmount)currencyConversion.apply((Object)this.min);
        another.sum = (MonetaryAmount)currencyConversion.apply((Object)this.sum);
        return another;
    }
}

