/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.util.Map;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import org.javamoney.moneta.function.DefaultMonetarySummaryStatistics;
import org.javamoney.moneta.function.MonetarySummaryMap;
import org.javamoney.moneta.function.MonetarySummaryStatistics;

public class GroupMonetarySummaryStatistics {
    private Map<CurrencyUnit, MonetarySummaryStatistics> groupSummary = new MonetarySummaryMap();

    GroupMonetarySummaryStatistics() {
    }

    public Map<CurrencyUnit, MonetarySummaryStatistics> get() {
        return this.groupSummary;
    }

    public GroupMonetarySummaryStatistics accept(MonetaryAmount amount) {
        CurrencyUnit currency = Objects.requireNonNull(amount).getCurrency();
        this.groupSummary.putIfAbsent(currency, new DefaultMonetarySummaryStatistics(currency));
        MonetarySummaryStatistics summary = this.groupSummary.get(currency);
        summary.accept(amount);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.groupSummary);
    }

    public boolean equals(Object obj) {
        if (GroupMonetarySummaryStatistics.class.isInstance(obj)) {
            GroupMonetarySummaryStatistics other = (GroupMonetarySummaryStatistics)GroupMonetarySummaryStatistics.class.cast(obj);
            return Objects.equals(this.groupSummary, other.groupSummary);
        }
        return false;
    }

    public String toString() {
        return "GroupMonetarySummaryStatistics: " + this.groupSummary.toString();
    }

    public GroupMonetarySummaryStatistics combine(GroupMonetarySummaryStatistics another) {
        Objects.requireNonNull(another);
        for (CurrencyUnit keyCurrency : another.groupSummary.keySet()) {
            this.groupSummary.putIfAbsent(keyCurrency, new DefaultMonetarySummaryStatistics(keyCurrency));
            this.groupSummary.merge(keyCurrency, another.groupSummary.get(keyCurrency), MonetarySummaryStatistics::combine);
        }
        return this;
    }
}

