/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.math.MathContext;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.money.CurrencyUnit;
import javax.money.MonetaryRounding;
import javax.money.MonetaryRoundings;
import javax.money.RoundingQuery;
import javax.money.spi.RoundingProviderSpi;
import org.javamoney.moneta.internal.DefaultCashRounding;
import org.javamoney.moneta.internal.DefaultRounding;

public class DefaultRoundingProvider
implements RoundingProviderSpi {
    public static final String DEFAULT_ROUNDING_ID = "default";
    private Set<String> roundingsIds = new HashSet<String>();

    public DefaultRoundingProvider() {
        this.roundingsIds.add(DEFAULT_ROUNDING_ID);
        this.roundingsIds = Collections.unmodifiableSet(this.roundingsIds);
    }

    public String getProviderName() {
        return DEFAULT_ROUNDING_ID;
    }

    public MonetaryRounding getRounding(RoundingQuery roundingQuery) {
        if (roundingQuery.get(LocalDateTime.class) != null || roundingQuery.get(LocalDate.class) != null) {
            return null;
        }
        CurrencyUnit currency = roundingQuery.getCurrency();
        if (currency != null) {
            RoundingMode roundingMode = (RoundingMode)((Object)roundingQuery.get(RoundingMode.class));
            if (roundingMode == null) {
                roundingMode = RoundingMode.HALF_EVEN;
            }
            if (Boolean.TRUE.equals(roundingQuery.getBoolean("cashRounding"))) {
                if (currency.getCurrencyCode().equals("CHF")) {
                    return new DefaultCashRounding(currency, RoundingMode.HALF_UP, 5);
                }
                return new DefaultCashRounding(currency, 1);
            }
            return new DefaultRounding(currency, roundingMode);
        }
        Integer scale = roundingQuery.getScale();
        if (scale == null) {
            scale = 2;
        }
        MathContext mc = (MathContext)roundingQuery.get(MathContext.class);
        RoundingMode roundingMode = (RoundingMode)((Object)roundingQuery.get(RoundingMode.class));
        if (mc != null) {
            return new DefaultRounding(scale, mc.getRoundingMode());
        }
        if (roundingMode != null) {
            return new DefaultRounding(scale, roundingMode);
        }
        if (roundingQuery.getRoundingName() != null && DEFAULT_ROUNDING_ID.equals(roundingQuery.getRoundingName())) {
            return MonetaryRoundings.getDefaultRounding();
        }
        return null;
    }

    public Set<String> getRoundingNames() {
        return this.roundingsIds;
    }
}

