/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.loader.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.loader.internal.ResourceCache;

public class DefaultResourceCache
implements ResourceCache {
    private static final Logger LOG = Logger.getLogger(DefaultResourceCache.class.getName());
    private static final String SUFFIX = ".dat";
    private File localDir = new File(System.getProperty("temp.dir", ".resourceCache"));
    private Map<String, File> cachedResources = new ConcurrentHashMap<String, File>();

    public DefaultResourceCache() {
        File[] files;
        if (!this.localDir.exists()) {
            if (!this.localDir.mkdirs()) {
                LOG.severe("Error creating cache dir  " + this.localDir + ", resource cache disabled!");
                this.localDir = null;
            } else {
                LOG.finest("Created cache dir  " + this.localDir);
            }
        } else if (!this.localDir.isDirectory()) {
            LOG.severe("Error initializing cache dir  " + this.localDir + ", not a directory, resource cache disabled!");
            this.localDir = null;
        } else if (!this.localDir.canWrite()) {
            LOG.severe("Error initializing cache dir  " + this.localDir + ", not writable, resource cache disabled!");
            this.localDir = null;
        }
        if (Objects.nonNull(this.localDir) && (files = this.localDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                String resourceId = file.getName().substring(0, file.getName().length() - 4);
                this.cachedResources.put(resourceId, file);
            }
        }
    }

    @Override
    public void write(String resourceId, byte[] data) {
        try {
            File f = this.cachedResources.get(resourceId);
            if (Objects.isNull(f)) {
                f = new File(this.localDir, resourceId + SUFFIX);
                this.writeFile(f, data);
                this.cachedResources.put(resourceId, f);
            } else {
                this.writeFile(f, data);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Caching of resource failed: " + resourceId, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File f, byte[] data) throws IOException {
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(f));
            bos.write(data);
            bos.flush();
        }
        finally {
            try {
                if (Objects.nonNull(bos)) {
                    bos.close();
                }
            }
            catch (Exception e2) {
                LOG.log(Level.SEVERE, "Error closing output stream for " + f, e2);
            }
        }
    }

    @Override
    public boolean isCached(String resourceId) {
        return this.cachedResources.containsKey(resourceId);
    }

    @Override
    public byte[] read(String resourceId) {
        File f = this.cachedResources.get(resourceId);
        if (Objects.isNull(f)) {
            return null;
        }
        return this.readFile(f);
    }

    @Override
    public void clear(String resourceId) {
        File f = this.cachedResources.get(resourceId);
        if (f != null) {
            if (f.exists() && !f.delete()) {
                LOG.warning("Failed to delete caching file: " + f.getAbsolutePath());
            }
            this.cachedResources.remove(resourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(File f) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(f));
            byte[] input = new byte[1024];
            int read = 1;
            while (read > 0) {
                read = is.read(input);
                if (read <= 0) continue;
                bos.write(input, 0, read);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error reading cached resource from " + f, e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (Objects.nonNull(is)) {
                    is.close();
                }
            }
            catch (Exception e2) {
                LOG.log(Level.SEVERE, "Error closing input stream from " + f, e2);
            }
        }
    }

    public String toString() {
        return "DefaultResourceCache [localDir=" + this.localDir + ", cachedResources=" + this.cachedResources + ']';
    }
}

