/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.NumberFormat;
import javax.money.MonetaryAmount;
import javax.money.MonetaryOperator;

final class Permil
implements MonetaryOperator {
    private static final MathContext DEFAULT_MATH_CONTEXT = Permil.initDefaultMathContext();
    private static final BigDecimal ONE_THOUSAND = new BigDecimal(1000, MathContext.DECIMAL64);
    private final BigDecimal permilValue;

    private static MathContext initDefaultMathContext() {
        return MathContext.DECIMAL64;
    }

    Permil(BigDecimal decimal) {
        this.permilValue = Permil.calcPermil(decimal);
    }

    public MonetaryAmount apply(MonetaryAmount amount) {
        return amount.multiply((Number)this.permilValue);
    }

    public String toString() {
        return NumberFormat.getInstance().format(this.permilValue.multiply(ONE_THOUSAND, DEFAULT_MATH_CONTEXT)) + " \u2030";
    }

    private static BigDecimal calcPermil(BigDecimal decimal) {
        return decimal.divide(ONE_THOUSAND, DEFAULT_MATH_CONTEXT);
    }
}

