/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.money.spi.ServiceProvider;

public class PriorityAwareServiceProvider
implements ServiceProvider {
    private final ConcurrentHashMap<Class, List<Object>> servicesLoaded = new ConcurrentHashMap();

    public int getPriority() {
        return 10;
    }

    public <T> List<T> getServices(Class<T> serviceType) {
        List<Object> found = this.servicesLoaded.get(serviceType);
        if (found != null) {
            return found;
        }
        return this.loadServices(serviceType);
    }

    public static int compareServices(Object o1, Object o2) {
        Priority prio2Annot;
        int prio1 = 0;
        int prio2 = 0;
        Priority prio1Annot = o1.getClass().getAnnotation(Priority.class);
        if (prio1Annot != null) {
            prio1 = prio1Annot.value();
        }
        if ((prio2Annot = o2.getClass().getAnnotation(Priority.class)) != null) {
            prio2 = prio2Annot.value();
        }
        if (prio1 < prio2) {
            return 1;
        }
        if (prio2 < prio1) {
            return -1;
        }
        return o2.getClass().getSimpleName().compareTo(o1.getClass().getSimpleName());
    }

    private <T> List<T> loadServices(Class<T> serviceType) {
        ArrayList<T> services = new ArrayList<T>();
        try {
            for (T t : ServiceLoader.load(serviceType)) {
                services.add(t);
            }
            services.sort(PriorityAwareServiceProvider::compareServices);
            ArrayList<T> previousServices = this.servicesLoaded.putIfAbsent(serviceType, services);
            return Collections.unmodifiableList(previousServices != null ? previousServices : services);
        }
        catch (Exception e) {
            Logger.getLogger(PriorityAwareServiceProvider.class.getName()).log(Level.WARNING, "Error loading services of type " + serviceType, e);
            services.sort(PriorityAwareServiceProvider::compareServices);
            return services;
        }
    }
}

