/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.convert;

import java.io.InputStream;
import java.math.MathContext;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ConversionQuery;
import javax.money.convert.CurrencyConversionException;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;
import javax.money.spi.Bootstrap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.javamoney.moneta.ExchangeRateBuilder;
import org.javamoney.moneta.internal.convert.RateReadingHandler;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LoaderService;
import org.xml.sax.helpers.DefaultHandler;

abstract class AbstractECBRateProvider
extends AbstractRateProvider
implements LoaderService.LoaderListener {
    private static final String BASE_CURRENCY_CODE = "EUR";
    public static final CurrencyUnit BASE_CURRENCY = Monetary.getCurrency((String)"EUR", (String[])new String[0]);
    protected final Map<LocalDate, Map<String, ExchangeRate>> rates = new ConcurrentHashMap<LocalDate, Map<String, ExchangeRate>>();
    private final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();

    AbstractECBRateProvider(ProviderContext context) {
        super(context);
        this.saxParserFactory.setNamespaceAware(false);
        this.saxParserFactory.setValidating(false);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        loader.addLoaderListener(this, this.getDataId());
        loader.loadDataAsync(this.getDataId());
    }

    protected abstract String getDataId();

    @Override
    public void newDataLoaded(String resourceId, InputStream is) {
        int oldSize = this.rates.size();
        try {
            SAXParser parser = this.saxParserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)new RateReadingHandler(this.rates, this.getContext()));
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Error during data load.", e);
        }
        int newSize = this.rates.size();
        this.log.info("Loaded " + resourceId + " exchange rates for days:" + (newSize - oldSize));
    }

    protected LocalDate[] getQueryDates(ConversionQuery query) {
        LocalDate date = (LocalDate)query.get(LocalDate.class);
        if (date == null) {
            LocalDateTime dateTime = (LocalDateTime)query.get(LocalDateTime.class);
            date = dateTime != null ? dateTime.toLocalDate() : LocalDate.now();
        }
        return new LocalDate[]{date, date.minus(Period.ofDays(1)), date.minus(Period.ofDays(2)), date.minus(Period.ofDays(3))};
    }

    @Override
    public ExchangeRate getExchangeRate(ConversionQuery conversionQuery) {
        Objects.requireNonNull(conversionQuery);
        if (this.rates.isEmpty()) {
            return null;
        }
        LocalDate[] dates = this.getQueryDates(conversionQuery);
        LocalDate selectedDate = null;
        Map<String, ExchangeRate> targets = null;
        for (LocalDate date : dates) {
            targets = this.rates.get(date);
            if (targets == null) continue;
            selectedDate = date;
            break;
        }
        if (Objects.isNull(targets)) {
            return null;
        }
        ExchangeRateBuilder builder = this.getBuilder(conversionQuery, selectedDate);
        ExchangeRate sourceRate = targets.get(conversionQuery.getBaseCurrency().getCurrencyCode());
        ExchangeRate target = targets.get(conversionQuery.getCurrency().getCurrencyCode());
        return this.createExchangeRate(conversionQuery, builder, sourceRate, target);
    }

    private ExchangeRate createExchangeRate(ConversionQuery query, ExchangeRateBuilder builder, ExchangeRate sourceRate, ExchangeRate target) {
        if (this.areBothBaseCurrencies(query)) {
            builder.setFactor(DefaultNumberValue.ONE);
            return builder.build();
        }
        if (BASE_CURRENCY_CODE.equals(query.getCurrency().getCurrencyCode())) {
            if (Objects.isNull(sourceRate)) {
                return null;
            }
            return this.reverse(sourceRate);
        }
        if (BASE_CURRENCY_CODE.equals(query.getBaseCurrency().getCurrencyCode())) {
            return target;
        }
        ExchangeRate rate1 = this.getExchangeRate(query.toBuilder().setTermCurrency(Monetary.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0])).build());
        ExchangeRate rate2 = this.getExchangeRate(query.toBuilder().setBaseCurrency(Monetary.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0])).setTermCurrency(query.getCurrency()).build());
        if (Objects.nonNull(rate1) && Objects.nonNull(rate2)) {
            builder.setFactor(AbstractECBRateProvider.multiply(rate1.getFactor(), rate2.getFactor()));
            builder.setRateChain(rate1, rate2);
            return builder.build();
        }
        throw new CurrencyConversionException(query.getBaseCurrency(), query.getCurrency(), sourceRate.getContext());
    }

    private boolean areBothBaseCurrencies(ConversionQuery query) {
        return BASE_CURRENCY_CODE.equals(query.getBaseCurrency().getCurrencyCode()) && BASE_CURRENCY_CODE.equals(query.getCurrency().getCurrencyCode());
    }

    private ExchangeRateBuilder getBuilder(ConversionQuery query, LocalDate localDate) {
        ExchangeRateBuilder builder = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)this.getContext(), (RateType)RateType.HISTORIC).set((Object)localDate)).build());
        builder.setBase(query.getBaseCurrency());
        builder.setTerm(query.getCurrency());
        return builder;
    }

    private ExchangeRate reverse(ExchangeRate rate) {
        if (Objects.isNull(rate)) {
            throw new IllegalArgumentException("Rate null is not reversible.");
        }
        return new ExchangeRateBuilder(rate).setRate(rate).setBase(rate.getCurrency()).setTerm(rate.getBaseCurrency()).setFactor(AbstractECBRateProvider.divide(DefaultNumberValue.ONE, rate.getFactor(), MathContext.DECIMAL64)).build();
    }
}

