/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.ecb;

import java.net.URI;
import java.util.HashMap;
import javax.money.convert.ProviderContext;
import javax.money.convert.ProviderContextBuilder;
import javax.money.convert.RateType;
import org.javamoney.moneta.convert.ecb.ECBAbstractRateProvider;
import org.javamoney.moneta.spi.loader.LoadDataInformation;
import org.javamoney.moneta.spi.loader.LoadDataInformationBuilder;
import org.javamoney.moneta.spi.loader.LoaderService;

public class ECBHistoricRateProvider
extends ECBAbstractRateProvider {
    private static final String DATA_ID = ECBHistoricRateProvider.class.getSimpleName();
    private static final ProviderContext CONTEXT = ((ProviderContextBuilder)((ProviderContextBuilder)ProviderContextBuilder.of((String)"ECB-HIST", (RateType)RateType.HISTORIC, (RateType[])new RateType[]{RateType.DEFERRED}).set("providerDescription", (Object)"European Central Bank")).set("days", 1500)).build();

    public ECBHistoricRateProvider() {
        super(CONTEXT, "https://www.ecb.europa.eu/stats/eurofxref/eurofxref-hist.xml");
    }

    @Override
    public String getDataId() {
        return DATA_ID;
    }

    @Override
    protected LoadDataInformation getDefaultLoadData() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("period", "24:00");
        props.put("delay", "01:00");
        props.put("at", "07:00");
        return new LoadDataInformationBuilder().withResourceId(this.getDataId()).withUpdatePolicy(LoaderService.UpdatePolicy.SCHEDULED).withProperties(props).withBackupResource(URI.create("org/javamoney/moneta/convert/ecb/defaults/eurofxref-hist.xml")).withResourceLocations(new URI[]{URI.create("https://www.ecb.europa.eu/stats/eurofxref/eurofxref-hist.xml")}).withStartRemote(false).build();
    }
}

