/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.ecb;

import java.net.URI;
import java.util.HashMap;
import javax.money.convert.ProviderContext;
import javax.money.convert.ProviderContextBuilder;
import javax.money.convert.RateType;
import org.javamoney.moneta.convert.ecb.ECBAbstractRateProvider;
import org.javamoney.moneta.spi.loader.LoadDataInformation;
import org.javamoney.moneta.spi.loader.LoadDataInformationBuilder;
import org.javamoney.moneta.spi.loader.LoaderService;

public class ECBHistoric90RateProvider
extends ECBAbstractRateProvider {
    private static final String DATA_ID = ECBHistoric90RateProvider.class.getSimpleName();
    private static final ProviderContext CONTEXT = ((ProviderContextBuilder)((ProviderContextBuilder)ProviderContextBuilder.of((String)"ECB-HIST90", (RateType)RateType.HISTORIC, (RateType[])new RateType[]{RateType.DEFERRED}).set("providerDescription", (Object)"European Central Bank (last 90 days)")).set("days", 90)).build();

    public ECBHistoric90RateProvider() {
        super(CONTEXT, "https://www.ecb.europa.eu/stats/eurofxref/eurofxref-hist-90d.xml");
    }

    @Override
    public String getDataId() {
        return DATA_ID;
    }

    @Override
    protected LoadDataInformation getDefaultLoadData() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("period", "03:00");
        return new LoadDataInformationBuilder().withResourceId(this.getDataId()).withUpdatePolicy(LoaderService.UpdatePolicy.SCHEDULED).withProperties(props).withBackupResource(URI.create("org/javamoney/moneta/convert/ecb/defaults/eurofxref-hist-90d.xml")).withResourceLocations(new URI[]{URI.create("https://www.ecb.europa.eu/stats/eurofxref/eurofxref-hist-90d.xml")}).withStartRemote(true).build();
    }
}

