/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.imf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.time.YearMonth;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.convert.imf.IMFHistoricalType;
import org.javamoney.moneta.convert.imf.IMFRemoteSearch;

class IMFRemoteSearchCallable
implements Callable<IMFRemoteSearchResult> {
    private static final Logger LOG = Logger.getLogger(IMFRemoteSearch.class.getName());
    private final IMFHistoricalType type;
    private final YearMonth yearMonth;
    private final String userAgent;

    IMFRemoteSearchCallable(IMFHistoricalType type, YearMonth yearMonth, String userAgent) {
        this.type = Objects.requireNonNull(type);
        this.yearMonth = Objects.requireNonNull(yearMonth);
        this.userAgent = Objects.requireNonNull(userAgent);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public IMFRemoteSearchResult call() throws Exception {
        URLConnection connection = this.getConnection();
        if (Objects.isNull(connection)) {
            return null;
        }
        connection.addRequestProperty("User-Agent", this.userAgent);
        try {
            Throwable throwable = null;
            try (InputStream inputStream = connection.getInputStream();){
                IMFRemoteSearchResult iMFRemoteSearchResult;
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                Throwable throwable2 = null;
                try {
                    byte[] data = new byte[4096];
                    int read = inputStream.read(data);
                    while (read > 0) {
                        stream.write(data, 0, read);
                        read = inputStream.read(data);
                    }
                    iMFRemoteSearchResult = new IMFRemoteSearchResult(this.type, new ByteArrayInputStream(stream.toByteArray()));
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            IMFRemoteSearchCallable.$closeResource(throwable2, stream);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                IMFRemoteSearchCallable.$closeResource(throwable2, stream);
                return iMFRemoteSearchResult;
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Failed to load resource from url " + this.type.getUrl(this.yearMonth), e);
            return null;
        }
    }

    private URLConnection getConnection() {
        try {
            return new URL(this.type.getUrl(this.yearMonth)).openConnection();
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Failed to load resource from url " + this.type.getUrl(this.yearMonth), e);
            return null;
        }
    }

    public String toString() {
        String sb = IMFRemoteSearchCallable.class.getName() + '{' + " type: " + (Object)((Object)this.type) + ", yearMonth: " + this.yearMonth + '}';
        return sb;
    }

    class IMFRemoteSearchResult {
        private final IMFHistoricalType type;
        private final InputStream stream;

        IMFRemoteSearchResult(IMFHistoricalType type, InputStream stream) {
            this.type = type;
            this.stream = stream;
        }

        public IMFHistoricalType getType() {
            return this.type;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public String toString() {
            String sb = IMFRemoteSearchResult.class.getName() + '{' + " type: " + (Object)((Object)this.type) + ", stream: " + this.stream + '}';
            return sb;
        }
    }
}

