/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.imf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.time.YearMonth;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.javamoney.moneta.convert.imf.IMFHistoricalType;

class IMFRemoteSearchCallable
implements Callable<IMFRemoteSearchResult> {
    private static final Logger LOG = Logger.getLogger(IMFRemoteSearchCallable.class.getName());
    private final IMFHistoricalType type;
    private final YearMonth yearMonth;
    private final String userAgent;

    IMFRemoteSearchCallable(IMFHistoricalType type, YearMonth yearMonth, String userAgent) {
        this.type = Objects.requireNonNull(type);
        this.yearMonth = Objects.requireNonNull(yearMonth);
        this.userAgent = userAgent;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public IMFRemoteSearchResult call() throws Exception {
        OkHttpClient client = new OkHttpClient.Builder().build();
        Request request = new Request.Builder().url(this.getUrl()).build();
        Call call = client.newCall(request);
        try (InputStream inputStream = call.execute().body().byteStream();){
            IMFRemoteSearchResult iMFRemoteSearchResult;
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                byte[] data = new byte[4096];
                int read = inputStream.read(data);
                while (read > 0) {
                    stream.write(data, 0, read);
                    read = inputStream.read(data);
                }
                iMFRemoteSearchResult = new IMFRemoteSearchResult(this.type, new ByteArrayInputStream(stream.toByteArray()));
            }
            return iMFRemoteSearchResult;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to load resource from url " + this.getUrl(), e);
            return null;
        }
    }

    private String getUrl() {
        return this.type.getUrl(this.yearMonth);
    }

    public String toString() {
        return IMFRemoteSearchCallable.class.getName() + '{' + " type: " + (Object)((Object)this.type) + ", yearMonth: " + this.yearMonth + '}';
    }

    static class IMFRemoteSearchResult {
        private final IMFHistoricalType type;
        private final InputStream stream;

        IMFRemoteSearchResult(IMFHistoricalType type, InputStream stream) {
            this.type = type;
            this.stream = stream;
        }

        public IMFHistoricalType getType() {
            return this.type;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public String toString() {
            return IMFRemoteSearchResult.class.getName() + '{' + " type: " + (Object)((Object)this.type) + ", stream: " + this.stream + '}';
        }
    }
}

