/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.imf;

import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.money.CurrencyUnit;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.ProviderContextBuilder;
import javax.money.convert.RateType;
import javax.money.spi.Bootstrap;
import org.javamoney.moneta.convert.imf.IMFAbstractRateProvider;
import org.javamoney.moneta.convert.imf.IMFHistoricalType;
import org.javamoney.moneta.convert.imf.IMFRateReadingHandler;
import org.javamoney.moneta.convert.imf.IMFRemoteSearch;
import org.javamoney.moneta.spi.loader.LoaderService;

public class IMFHistoricRateProvider
extends IMFAbstractRateProvider {
    private static final Logger LOG = Logger.getLogger(IMFHistoricRateProvider.class.getName());
    private static final String DATA_ID = IMFHistoricRateProvider.class.getSimpleName();
    private static final ProviderContext CONTEXT = ((ProviderContextBuilder)((ProviderContextBuilder)((ProviderContextBuilder)ProviderContextBuilder.of((String)"IMF-HIST", (RateType)RateType.HISTORIC, (RateType[])new RateType[0]).set("providerDescription", (Object)"Historic International Monetary Fund")).set("days", 0)).set("User-Agent", (Object)"Chrome/51.0.2704.103")).build();
    private final List<YearMonth> cachedHistoric = new ArrayList<YearMonth>();

    public IMFHistoricRateProvider() {
        super(CONTEXT);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        loader.addLoaderListener((LoaderService.LoaderListener)this, new String[]{DATA_ID});
        try {
            loader.loadData(DATA_ID);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Error loading initial data from IMF provider...", e);
        }
    }

    @Override
    public ExchangeRate getExchangeRate(ConversionQuery conversionQuery) {
        LocalDate[] times = this.getQueryDates(conversionQuery);
        if (Objects.isNull(times)) {
            return super.getExchangeRate(conversionQuery);
        }
        for (YearMonth yearMonth : Stream.of(times).map(YearMonth::from).collect(Collectors.toSet())) {
            if (this.cachedHistoric.contains(yearMonth)) continue;
            Map<IMFHistoricalType, InputStream> resources = IMFRemoteSearch.INSTANCE.getResources(yearMonth, (String)this.getContext().get("User-Agent", String.class));
            this.loadFromRemote(resources);
            this.cachedHistoric.add(yearMonth);
        }
        return super.getExchangeRate(conversionQuery);
    }

    private void loadFromRemote(Map<IMFHistoricalType, InputStream> resources) {
        try {
            for (IMFHistoricalType type : resources.keySet()) {
                IMFRateReadingHandler.RateIMFResult result = this.handler.read(resources.get((Object)type));
                this.combine(result.getSdrToCurrency(), this.sdrToCurrency);
                this.combine(result.getCurrencyToSdr(), this.currencyToSdr);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error", e);
        }
    }

    private Map<CurrencyUnit, List<ExchangeRate>> combine(Map<CurrencyUnit, List<ExchangeRate>> source, Map<CurrencyUnit, List<ExchangeRate>> destination) {
        for (CurrencyUnit currency : source.keySet()) {
            destination.putIfAbsent(currency, new ArrayList());
            List<ExchangeRate> rates = source.get(currency);
            destination.merge(currency, rates, IMFHistoricRateProvider::merge);
        }
        return destination;
    }

    private static List<ExchangeRate> merge(List<ExchangeRate> ratesA, List<ExchangeRate> ratesB) {
        ratesA.addAll(ratesB);
        ratesA.sort(COMPARATOR_EXCHANGE_BY_LOCAL_DATE.reversed());
        return ratesA;
    }
}

