/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.MonetaryException;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ExchangeRateProvider;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryConversionsSingletonSpi;
import org.javamoney.moneta.spi.CompoundRateProvider;
import org.javamoney.moneta.spi.MonetaryConfig;

public class DefaultMonetaryConversionsSingletonSpi
implements MonetaryConversionsSingletonSpi {
    private static final Logger LOG = Logger.getLogger(DefaultMonetaryConversionsSingletonSpi.class.getName());
    private Map<String, ExchangeRateProvider> conversionProviders = new ConcurrentHashMap<String, ExchangeRateProvider>();

    public DefaultMonetaryConversionsSingletonSpi() {
        this.reload();
    }

    public void reload() {
        ConcurrentHashMap<String, ExchangeRateProvider> newProviders = new ConcurrentHashMap<String, ExchangeRateProvider>();
        for (ExchangeRateProvider prov : Bootstrap.getServices(ExchangeRateProvider.class)) {
            newProviders.put(prov.getContext().getProviderName(), prov);
        }
        this.conversionProviders = newProviders;
    }

    public ExchangeRateProvider getExchangeRateProvider(ConversionQuery conversionQuery) {
        Collection<String> providers = this.getProvidersToUse(conversionQuery);
        ArrayList<ExchangeRateProvider> provInstances = new ArrayList<ExchangeRateProvider>();
        for (String provName : providers) {
            ExchangeRateProvider prov = Optional.ofNullable(this.conversionProviders.get(provName)).orElseThrow(() -> new MonetaryException("Unsupported conversion/rate provider: " + provName));
            provInstances.add(prov);
        }
        if (provInstances.isEmpty()) {
            throw new MonetaryException("No such providers: " + conversionQuery);
        }
        if (provInstances.size() == 1) {
            return (ExchangeRateProvider)provInstances.get(0);
        }
        return new CompoundRateProvider(provInstances);
    }

    public boolean isExchangeRateProviderAvailable(ConversionQuery conversionQuery) {
        Collection<String> providers = this.getProvidersToUse(conversionQuery);
        return !providers.isEmpty();
    }

    public boolean isConversionAvailable(ConversionQuery conversionQuery) {
        try {
            if (this.isExchangeRateProviderAvailable(conversionQuery)) {
                return this.getExchangeRateProvider(conversionQuery).getCurrencyConversion(conversionQuery) != null;
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINEST, "Error during availability check for conversion: " + conversionQuery, e);
        }
        return false;
    }

    public ExchangeRateProvider getExchangeRateProvider(String ... providers) {
        ArrayList<ExchangeRateProvider> provInstances = new ArrayList<ExchangeRateProvider>();
        for (String provName : providers) {
            ExchangeRateProvider prov = Optional.ofNullable(this.conversionProviders.get(provName)).orElseThrow(() -> new MonetaryException("Unsupported conversion/rate provider: " + provName));
            provInstances.add(prov);
        }
        if (provInstances.size() == 1) {
            return (ExchangeRateProvider)provInstances.get(0);
        }
        return new CompoundRateProvider(provInstances);
    }

    private Collection<String> getProvidersToUse(ConversionQuery query) {
        ArrayList<String> providersToUse = new ArrayList<String>();
        List<String> providerNames = query.getProviderNames();
        if (providerNames.isEmpty() && (providerNames = this.getDefaultProviderChain()).isEmpty()) {
            throw new IllegalStateException("No default provider chain available.");
        }
        for (String provider : providerNames) {
            ExchangeRateProvider prov = this.conversionProviders.get(provider);
            if (prov == null) {
                throw new MonetaryException("Invalid ExchangeRateProvider (not found): " + provider);
            }
            providersToUse.add(provider);
        }
        return providersToUse;
    }

    public Set<String> getProviderNames() {
        return this.conversionProviders.keySet();
    }

    public List<String> getDefaultProviderChain() {
        ArrayList<String> provList = new ArrayList<String>();
        String defaultChain = MonetaryConfig.getString((String)"conversion.default-chain").orElse(null);
        if (defaultChain != null) {
            String[] items;
            for (String item : items = defaultChain.split(",")) {
                if (this.getProviderNames().contains(item.trim())) {
                    provList.add(item);
                    continue;
                }
                LOG.warning("Ignoring non existing default provider: " + item);
            }
        } else {
            Bootstrap.getServices(ExchangeRateProvider.class).forEach(p -> provList.add(p.getContext().getProviderName()));
        }
        return provList;
    }
}

