//////////////////////////////////////////////////////////////////////
//
// The JavaPOS library source code is now under the CPL license, which 
// is an OSS Apache-like license. The complete license is located at:
//    http://www.ibm.com/developerworks/library/os-cpl.html
//
//////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
//
// This software is provided "AS IS".  The JavaPOS working group (including
// each of the Corporate members, contributors and individuals)  MAKES NO
// REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE SOFTWARE,
// EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
// WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NON-INFRINGEMENT. The JavaPOS working group shall not be liable for
// any damages suffered as a result of using, modifying or distributing this
// software or its derivatives.Permission to use, copy, modify, and distribute
// the software and its documentation for any purpose is hereby granted.
//
// POSPrinterService113
//
//   Interface definining all new capabilities, properties and
//   methods that are specific to POS Printer for release 1.13.
//
// Modification history
// ------------------------------------------------------------------
// 2009-Feb-23 JavaPOS Release 1.13                                BS
//
/////////////////////////////////////////////////////////////////////

package jpos.services;

import jpos.*;

public interface POSPrinterService113 extends POSPrinterService112
{
  // Capabilities
  public int getCapRecRuledLine() throws JposException;
  public int getCapSlpRuledLine() throws JposException;

  // Methods
  public void drawRuledLine(int station, String positionList,
                            int lineDirection, int lineWidth,
                            int lineStyle, int lineColor)
    throws JposException;
}