//////////////////////////////////////////////////////////////////////
//
// The JavaPOS library source code is now under the CPL license, which 
// is an OSS Apache-like license. The complete license is located at:
//    http://www.ibm.com/developerworks/library/os-cpl.html
//
//////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
//
// THIS SOFTWARE IS PROVIDED AS IS. THE JAVAPOS WORKING GROUP MAKES NO
// REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE SOFTWARE,
// EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
// WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
// NON-INFRINGEMENT.  INDIVIDUAL OR CORPORATE MEMBERS OF THE JAVAPOS
// WORKING GROUP SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED AS A RESULT
// OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
//
// JposEvent
//
//   Base class for all events generated by JavaPOS device controls.
//
// Modification history
// ------------------------------------------------------------------
// 98-02-18 JavaPOS Release 1.2                                   BS
// 98-11-02 Added getSequenceNumber() method.                     BS
// 99-10-04 Added initialization of when field.                   BS
//
/////////////////////////////////////////////////////////////////////

package jpos.events;

public abstract class JposEvent extends java.util.EventObject
{
    public JposEvent(Object source)
    {
        super(source);
        updateSequenceNumber();
        when = System.currentTimeMillis();
    }

    public synchronized final void updateSequenceNumber()
    {
        sequenceNumber = incrSequenceNumber();
    }

    public static final synchronized long incrSequenceNumber()
    {
        return ++globalSequenceNumber;
    }

    public final long getSequenceNumber()
    {
      return sequenceNumber;
    }

    public long getWhen()
    {
        return when;
    }

    protected      long   sequenceNumber;
    private static long   globalSequenceNumber = 0;
    private        long   when;
}