//////////////////////////////////////////////////////////////////////
//
// The JavaPOS library source code is now under the CPL license, which 
// is an OSS Apache-like license. The complete license is located at:
//    http://www.ibm.com/developerworks/library/os-cpl.html
//
//////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
//
// This software is provided "AS IS".  The JavaPOS working group (including
// each of the Corporate members, contributors and individuals)  MAKES NO
// REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE SOFTWARE,
// EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
// WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NON-INFRINGEMENT. The JavaPOS working group shall not be liable for
// any damages suffered as a result of using, modifying or distributing this
// software or its derivatives.Permission to use, copy, modify, and distribute
// the software and its documentation for any purpose is hereby granted.
//
// BumpBarConst
//
//   Bump Bar constants for JavaPOS Applications.
//
// Modification history
// ------------------------------------------------------------------
// 98-04-20 JavaPOS Release 1.3                                   BS
//
/////////////////////////////////////////////////////////////////////

package jpos;

public interface BumpBarConst
{
    /////////////////////////////////////////////////////////////////////
    // "CurrentUnitID" and "UnitsOnline" Properties
    //  and "Units" Parameter Constants
    /////////////////////////////////////////////////////////////////////

    public static final int BB_UID_1  = 0x00000001;
    public static final int BB_UID_2  = 0x00000002;
    public static final int BB_UID_3  = 0x00000004;
    public static final int BB_UID_4  = 0x00000008;
    public static final int BB_UID_5  = 0x00000010;
    public static final int BB_UID_6  = 0x00000020;
    public static final int BB_UID_7  = 0x00000040;
    public static final int BB_UID_8  = 0x00000080;
    public static final int BB_UID_9  = 0x00000100;
    public static final int BB_UID_10 = 0x00000200;
    public static final int BB_UID_11 = 0x00000400;
    public static final int BB_UID_12 = 0x00000800;
    public static final int BB_UID_13 = 0x00001000;
    public static final int BB_UID_14 = 0x00002000;
    public static final int BB_UID_15 = 0x00004000;
    public static final int BB_UID_16 = 0x00008000;
    public static final int BB_UID_17 = 0x00010000;
    public static final int BB_UID_18 = 0x00020000;
    public static final int BB_UID_19 = 0x00040000;
    public static final int BB_UID_20 = 0x00080000;
    public static final int BB_UID_21 = 0x00100000;
    public static final int BB_UID_22 = 0x00200000;
    public static final int BB_UID_23 = 0x00400000;
    public static final int BB_UID_24 = 0x00800000;
    public static final int BB_UID_25 = 0x01000000;
    public static final int BB_UID_26 = 0x02000000;
    public static final int BB_UID_27 = 0x04000000;
    public static final int BB_UID_28 = 0x08000000;
    public static final int BB_UID_29 = 0x10000000;
    public static final int BB_UID_30 = 0x20000000;
    public static final int BB_UID_31 = 0x40000000;
    public static final int BB_UID_32 = 0x80000000;


    /////////////////////////////////////////////////////////////////////
    // "DataEvent" Event: "Status" Parameter Constants
    /////////////////////////////////////////////////////////////////////

    public static final int BB_DE_KEY = 0x01;
}