/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.json;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.javasimon.console.json.AnyJS;
import org.javasimon.console.json.ObjectJS;
import org.javasimon.console.text.StringifierFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayJS
extends AnyJS {
    private List<AnyJS> elements;

    public ArrayJS() {
        this.elements = new ArrayList<AnyJS>();
    }

    public ArrayJS(int size) {
        this.elements = new ArrayList<AnyJS>(size);
    }

    public ArrayJS(List<AnyJS> elements) {
        this.elements = elements;
    }

    public List<AnyJS> getElements() {
        return this.elements;
    }

    public void addElement(AnyJS element) {
        this.elements.add(element);
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write("[");
        boolean first = true;
        for (AnyJS element : this.elements) {
            if (first) {
                first = false;
            } else {
                writer.write(",");
            }
            element.write(writer);
        }
        writer.write("]");
    }

    public static ArrayJS create(Collection<?> objects, StringifierFactory stringifierFactory) {
        if (objects == null) {
            return null;
        }
        ArrayJS arrayJS = new ArrayJS(objects.size());
        for (Object object : objects) {
            arrayJS.addElement(ObjectJS.create(object, stringifierFactory));
        }
        return arrayJS;
    }

    public static ArrayJS create(Object[] objects, StringifierFactory stringifierFactory) {
        if (objects == null) {
            return null;
        }
        ArrayJS arrayJS = new ArrayJS(objects.length);
        for (Object object : objects) {
            arrayJS.addElement(ObjectJS.create(object, stringifierFactory));
        }
        return arrayJS;
    }
}

