/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.html;

import java.io.IOException;
import java.io.Writer;
import org.javasimon.Simon;
import org.javasimon.console.SimonType;
import org.javasimon.console.html.HtmlResource;
import org.javasimon.console.html.HtmlResourceType;
import org.javasimon.console.reflect.Getter;
import org.javasimon.console.reflect.GetterFactory;
import org.javasimon.console.text.StringifierFactory;

public class HtmlBuilder<T extends HtmlBuilder> {
    private final Writer writer;
    private final StringifierFactory stringifierFactory;

    public HtmlBuilder(Writer writer) {
        this.writer = writer;
        this.stringifierFactory = null;
    }

    public HtmlBuilder(Writer writer, StringifierFactory stringifierFactory) {
        this.writer = writer;
        this.stringifierFactory = stringifierFactory;
    }

    private void doBegin(String element, String id, String cssClass) throws IOException {
        this.writer.write(60);
        this.writer.write(element);
        this.attr("id", id);
        this.attr("class", cssClass);
    }

    public T attr(String name, String value) throws IOException {
        if (value != null) {
            this.writer.write(32);
            this.writer.write(name);
            this.writer.write("=\"");
            this.writer.write(value);
            this.writer.write(34);
        }
        return (T)this;
    }

    public T begin(String element, String id, String cssClass) throws IOException {
        this.doBegin(element, id, cssClass);
        this.writer.write(62);
        return (T)this;
    }

    public T begin(String element) throws IOException {
        return this.begin(element, null, null);
    }

    public T element(String element, String id, String cssClass) throws IOException {
        this.doBegin(element, id, cssClass);
        this.writer.write(" />");
        return (T)this;
    }

    public T end(String element) throws IOException {
        this.writer.write("</");
        this.writer.write(element);
        this.writer.write(62);
        return (T)this;
    }

    public T text(String text) throws IOException {
        if (text != null) {
            this.writer.write(text);
        }
        return (T)this;
    }

    public T write(String text) throws IOException {
        this.writer.write(text);
        return (T)this;
    }

    private T cssResource(String path) throws IOException {
        return ((HtmlBuilder)((HtmlBuilder)this.write("<link href=\"../resource/")).write(path)).write("\" rel=\"stylesheet\" type=\"text/css\" />");
    }

    private T resources(Iterable<HtmlResource> resources) throws IOException {
        this.cssResource("css/javasimon.css");
        for (HtmlResource resource : resources) {
            if (resource.getType() != HtmlResourceType.CSS) continue;
            this.cssResource(resource.getPath());
        }
        for (HtmlResource resource : resources) {
            if (resource.getType() != HtmlResourceType.JS) continue;
            ((HtmlBuilder)((HtmlBuilder)this.write("<script src=\"../resource/")).write(resource.getPath())).write("\" type=\"text/javascript\"></script>");
        }
        return (T)this;
    }

    public T header(String title, Iterable<HtmlResource> resources) throws IOException {
        return ((HtmlBuilder)((HtmlBuilder)((HtmlBuilder)((HtmlBuilder)((HtmlBuilder)((HtmlBuilder)((HtmlBuilder)super.resources(resources)).end("head")).begin("body")).begin("h1")).write("<img id=\"logo\" src=\"../resource/images/logo.png\" alt=\"Logo\" />")).text("Simon Console: ")).text(title)).end("h1");
    }

    public T footer() throws IOException {
        return ((HtmlBuilder)this.end("body")).end("html");
    }

    public <X> T value(X value, String subType) throws IOException {
        return this.text(this.stringifierFactory.toString(value, subType));
    }

    public T simonProperty(Simon simon, String propertyName) throws IOException {
        Getter getter = GetterFactory.getGetter(simon.getClass(), propertyName);
        if (getter != null) {
            this.value(getter.get(simon), getter.getSubType());
        }
        return (T)this;
    }

    public T object(Object object) throws IOException {
        this.text(this.stringifierFactory.toString(object));
        return (T)this;
    }

    public T simonTypeImg(SimonType simonType, String rootPath) throws IOException {
        String image = null;
        switch (simonType) {
            case COUNTER: {
                image = "TypeCounter.png";
                break;
            }
            case STOPWATCH: {
                image = "TypeStopwatch.png";
                break;
            }
            case UNKNOWN: {
                image = "TypeUnknown.png";
            }
        }
        String label = simonType.name().toLowerCase();
        this.doBegin("img", null, label + " icon");
        this.attr("src", rootPath + "resource/images/" + image);
        this.attr("alt", label);
        this.writer.write(" />");
        return (T)this;
    }
}

