/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.action;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.javasimon.console.Action;
import org.javasimon.console.ActionContext;
import org.javasimon.console.ActionException;

public class ResourceAction
extends Action {
    public static final String PREFIX = "/resource";
    private static final Map<String, String> CONTENT_TYPES = new HashMap<String, String>();
    private final String resourcePath;

    public ResourceAction(ActionContext context, String resourcePath) {
        super(context);
        this.resourcePath = resourcePath.startsWith("/") ? resourcePath : "/" + resourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ServletException, IOException, ActionException {
        try (InputStream resourceIStream = null;){
            resourceIStream = this.getClass().getResourceAsStream("/org/javasimon/console/resource" + this.resourcePath);
            if (resourceIStream == null) {
                this.getContext().getResponse().setStatus(404);
                throw new ActionException("Resource " + this.resourcePath + " not found");
            }
            String extension = this.resourcePath.substring(this.resourcePath.lastIndexOf(46) + 1).toLowerCase();
            String contentType = CONTENT_TYPES.get(extension);
            if (contentType != null) {
                this.getContext().setContentType(contentType);
                if (contentType.startsWith("text")) {
                    this.getContext().getResponse().setCharacterEncoding("UTF-8");
                }
            }
            this.getContext().getResponse().setHeader("Cache-Control", "public; max-age=300");
            this.copyStream(resourceIStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStream(InputStream inputStream) throws IOException {
        OutputStream outputStream = null;
        try {
            int bufferLen;
            outputStream = this.getContext().getOutputStream();
            byte[] buffer = new byte[65535];
            int totalLen = 0;
            while ((bufferLen = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, bufferLen);
                totalLen += bufferLen;
            }
            this.getContext().getResponse().setContentLength(totalLen);
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
            }
        }
    }

    static {
        CONTENT_TYPES.put("gif", "image/gif");
        CONTENT_TYPES.put("png", "image/png");
        CONTENT_TYPES.put("jpg", "image/jpeg");
        CONTENT_TYPES.put("html", "text/html");
        CONTENT_TYPES.put("css", "text/css");
        CONTENT_TYPES.put("js", "text/javascript");
    }
}

