/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.javaee;

import javax.servlet.http.HttpServletRequest;
import org.javasimon.Manager;
import org.javasimon.Stopwatch;
import org.javasimon.javaee.SimonServletFilterUtils;
import org.javasimon.source.AbstractStopwatchSource;
import org.javasimon.source.CachedStopwatchSource;
import org.javasimon.source.StopwatchSource;
import org.javasimon.utils.Replacer;

public class HttpStopwatchSource
extends AbstractStopwatchSource<HttpServletRequest> {
    public static final String DEFAULT_SIMON_PREFIX = "org.javasimon.web";
    private static final String GET_METHOD = "GET";
    private String prefix = "org.javasimon.web";
    private IncludeHttpMethodName includeHttpMethodName = IncludeHttpMethodName.NEVER;
    private Replacer unallowedCharacterReplacer = SimonServletFilterUtils.createUnallowedCharsReplacer("_");
    private Replacer jsessionParameterReplacer = new Replacer("[;&]?JSESSIONID=[^;?/&]*", "", new Replacer.Modificator[]{Replacer.Modificator.IGNORE_CASE});
    private Replacer trailingStuffReplacer = new Replacer("/[^a-zA-Z]*$", "", new Replacer.Modificator[0]);

    public HttpStopwatchSource(Manager manager) {
        super(manager);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getReplaceUnallowed() {
        return this.unallowedCharacterReplacer.getTo();
    }

    public void setReplaceUnallowed(String replaceUnallowed) {
        this.unallowedCharacterReplacer.setTo(replaceUnallowed);
    }

    public IncludeHttpMethodName getIncludeHttpMethodName() {
        return this.includeHttpMethodName;
    }

    public void setIncludeHttpMethodName(IncludeHttpMethodName includeHttpMethodName) {
        this.includeHttpMethodName = includeHttpMethodName;
    }

    protected String getMonitorName(HttpServletRequest request) {
        String uri = this.requestToStringForMonitorName(request);
        String localName = SimonServletFilterUtils.getSimonName(uri, this.unallowedCharacterReplacer);
        String monitorName = this.prefix == null || this.prefix.isEmpty() ? localName : this.prefix + "." + localName;
        if (this.includeMethodName(request)) {
            monitorName = monitorName + "." + request.getMethod();
        }
        return monitorName;
    }

    private boolean includeMethodName(HttpServletRequest request) {
        return this.includeHttpMethodName == IncludeHttpMethodName.ALWAYS || this.includeHttpMethodName == IncludeHttpMethodName.NON_GET && !request.getMethod().equals(GET_METHOD);
    }

    protected String requestToStringForMonitorName(HttpServletRequest request) {
        String uri = request.getRequestURI();
        uri = this.removeJSessionIdFromUri(uri);
        uri = this.removeTrailingStuff(uri);
        return uri;
    }

    protected String removeJSessionIdFromUri(String uri) {
        return this.jsessionParameterReplacer.process(uri);
    }

    protected String removeTrailingStuff(String uri) {
        return this.trailingStuffReplacer.process(uri);
    }

    public boolean isMonitored(HttpServletRequest httpServletRequest) {
        String uri = httpServletRequest.getRequestURI().toLowerCase();
        return !uri.endsWith(".css") && !uri.endsWith(".png") && !uri.endsWith(".gif") && !uri.endsWith(".jpg") && !uri.endsWith(".js");
    }

    public Stopwatch getMonitor(HttpServletRequest request) {
        Stopwatch stopwatch = super.getMonitor((Object)request);
        if (stopwatch.getNote() == null) {
            stopwatch.setNote(request.getRequestURI());
        }
        return stopwatch;
    }

    public static StopwatchSource<HttpServletRequest> newCacheStopwatchSource(StopwatchSource<HttpServletRequest> stopwatchSource) {
        return new CachedStopwatchSource<HttpServletRequest, String>(stopwatchSource){

            protected String getLocationKey(HttpServletRequest location) {
                return location.getRequestURI();
            }
        };
    }

    public static enum IncludeHttpMethodName {
        ALWAYS,
        NEVER,
        NON_GET;

    }
}

