/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.javaee;

import java.lang.reflect.InvocationTargetException;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import org.javasimon.Manager;
import org.javasimon.Stopwatch;
import org.javasimon.javaee.HttpStopwatchSource;
import org.javasimon.javaee.reqreporter.DefaultRequestReporter;
import org.javasimon.javaee.reqreporter.RequestReporter;
import org.javasimon.source.MonitorSource;
import org.javasimon.source.StopwatchSource;
import org.javasimon.utils.Replacer;

public class SimonServletFilterUtils {
    private static final Replacer TO_DOT_PATTERN = new Replacer("[/.]+", ".", new Replacer.Modificator[0]);

    static Replacer createUnallowedCharsReplacer(String replacement) {
        return new Replacer("[^" + "-_\\[\\]A-Za-z0-9.,@$%)(<>".replace('.', '/') + "]+", replacement, new Replacer.Modificator[0]);
    }

    public static String getSimonName(String uri, Replacer unallowedCharacterReplacer) {
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        String name = unallowedCharacterReplacer.process(uri);
        name = TO_DOT_PATTERN.process(name);
        return name;
    }

    protected static StopwatchSource<HttpServletRequest> initStopwatchSource(FilterConfig filterConfig, Manager manager) {
        String stopwatchSourceClass = filterConfig.getInitParameter("stopwatch-source-class");
        StopwatchSource<HttpServletRequest> stopwatchSource = SimonServletFilterUtils.createMonitorSource(stopwatchSourceClass, manager);
        SimonServletFilterUtils.injectSimonPrefixIntoMonitorSource(filterConfig, stopwatchSource);
        String cache = filterConfig.getInitParameter("stopwatch-source-cache");
        stopwatchSource = SimonServletFilterUtils.wrapMonitorSourceWithCacheIfNeeded(stopwatchSource, cache);
        return stopwatchSource;
    }

    private static StopwatchSource<HttpServletRequest> createMonitorSource(String stopwatchSourceClass, Manager manager) {
        if (stopwatchSourceClass == null) {
            return new HttpStopwatchSource(manager);
        }
        return SimonServletFilterUtils.createMonitorForSourceSpecifiedClass(stopwatchSourceClass, manager);
    }

    private static void injectSimonPrefixIntoMonitorSource(FilterConfig filterConfig, MonitorSource<HttpServletRequest, Stopwatch> stopwatchSource) {
        String simonPrefix = filterConfig.getInitParameter("prefix");
        if (simonPrefix != null) {
            if (stopwatchSource instanceof HttpStopwatchSource) {
                HttpStopwatchSource httpStopwatchSource = (HttpStopwatchSource)stopwatchSource;
                httpStopwatchSource.setPrefix(simonPrefix);
            } else {
                throw new IllegalArgumentException("Prefix init param is only compatible with HttpStopwatchSource");
            }
        }
    }

    private static StopwatchSource<HttpServletRequest> wrapMonitorSourceWithCacheIfNeeded(StopwatchSource<HttpServletRequest> stopwatchSource, String cache) {
        if (cache != null && Boolean.parseBoolean(cache)) {
            stopwatchSource = HttpStopwatchSource.newCacheStopwatchSource(stopwatchSource);
        }
        return stopwatchSource;
    }

    private static StopwatchSource<HttpServletRequest> createMonitorForSourceSpecifiedClass(String stopwatchSourceClass, Manager manager) {
        try {
            Class<?> monitorClass = Class.forName(stopwatchSourceClass);
            return SimonServletFilterUtils.monitorSourceNewInstance(manager, monitorClass);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Invalid Stopwatch source class name", e);
        }
    }

    private static StopwatchSource<HttpServletRequest> monitorSourceNewInstance(Manager manager, Class<?> monitorClass) throws InstantiationException, IllegalAccessException {
        StopwatchSource stopwatchSource = null;
        try {
            stopwatchSource = (StopwatchSource)monitorClass.getConstructor(Manager.class).newInstance(manager);
        }
        catch (NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        if (stopwatchSource == null) {
            stopwatchSource = (StopwatchSource)monitorClass.newInstance();
            try {
                monitorClass.getMethod("setManager", Manager.class).invoke((Object)stopwatchSource, manager);
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Stopwatch source class must have public constructor or public setter with Manager argument (used class " + monitorClass.getName() + ")", e);
            }
        }
        return stopwatchSource;
    }

    public static RequestReporter initRequestReporter(FilterConfig filterConfig) {
        String className = filterConfig.getInitParameter("request-reporter-class");
        if (className == null) {
            return new DefaultRequestReporter();
        }
        try {
            return (RequestReporter)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException classNotFoundException) {
            throw new IllegalArgumentException("Invalid Request reporter class name", classNotFoundException);
        }
    }
}

