/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbcx4;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Properties;
import org.javasimon.jdbc4.SimonConnectionConfiguration;

public abstract class AbstractSimonDataSource {
    protected transient PrintWriter logWriter;
    protected SimonConnectionConfiguration configuration;
    private String user;
    private String password;
    private int loginTimeout;
    private String realDataSourceClassName;
    private String prefix;
    private Properties properties;

    public final PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public final void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    public final String getUrl() {
        return this.configuration == null ? null : this.configuration.getSimonUrl();
    }

    public final void setUrl(String url) {
        this.configuration = new SimonConnectionConfiguration(url);
    }

    public final String getRealUrl() {
        return this.configuration == null ? null : this.configuration.getRealUrl();
    }

    public final String getUser() {
        return this.user;
    }

    public final void setUser(String user) {
        this.user = user;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    public final int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public final String getRealDataSourceClassName() {
        if ((this.realDataSourceClassName == null || this.realDataSourceClassName.isEmpty()) && this.configuration != null) {
            this.realDataSourceClassName = this.doGetRealDataSourceClassName();
        }
        return this.realDataSourceClassName;
    }

    public final void setRealDataSourceClassName(String className) {
        this.realDataSourceClassName = className;
    }

    protected final <T> T createDataSource(Class<T> dataSourceClass) throws SQLException {
        if (this.getRealDataSourceClassName() == null) {
            throw new SQLException("Property realDataSourceClassName is not set");
        }
        try {
            T ds = dataSourceClass.cast(Class.forName(this.realDataSourceClassName).newInstance());
            for (Method m : ds.getClass().getMethods()) {
                Object propertyValue;
                String methodName = m.getName();
                if (!methodName.startsWith("set") || m.getParameterTypes().length != 1) continue;
                if (methodName.equals("setUser")) {
                    propertyValue = this.getUser();
                } else if (methodName.equals("setPassword")) {
                    propertyValue = this.getPassword();
                } else if (methodName.equalsIgnoreCase("setUrl")) {
                    propertyValue = this.getRealUrl();
                } else if (methodName.equals("setLogWriter")) {
                    propertyValue = this.getLogWriter();
                } else if (methodName.equals("setLoginTimeout")) {
                    propertyValue = this.getLoginTimeout();
                } else {
                    String propertyName = methodName.substring(3, 4).toLowerCase();
                    if (methodName.length() > 4) {
                        propertyName = propertyName + methodName.substring(4);
                    }
                    Class<?> propertyType = m.getParameterTypes()[0];
                    propertyValue = this.getPropertyAs(propertyName, propertyType);
                }
                if (propertyValue == null) continue;
                m.invoke(ds, propertyValue);
            }
            return ds;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    protected abstract String doGetRealDataSourceClassName();

    public final String getPrefix() {
        if ((this.prefix == null || this.prefix.isEmpty()) && this.configuration != null) {
            this.prefix = this.configuration.getPrefix();
        }
        return this.prefix;
    }

    public final void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private <T> T getPropertyAs(String propertyName, Class<T> propertyType) {
        String sValue;
        String string = sValue = this.properties == null ? null : this.properties.getProperty(propertyName);
        Object value = sValue == null ? null : (propertyType.equals(String.class) ? (Object)propertyType.cast(sValue) : (propertyType.equals(Integer.class) ? (Object)propertyType.cast(Integer.valueOf(sValue)) : (propertyType.equals(Integer.TYPE) ? Integer.valueOf(sValue) : (propertyType.equals(Long.class) ? propertyType.cast(Long.valueOf(sValue)) : (propertyType.equals(Long.TYPE) ? Long.valueOf(sValue) : (propertyType.equals(Boolean.class) ? propertyType.cast(Boolean.valueOf(sValue)) : (propertyType.equals(Boolean.TYPE) ? Boolean.valueOf(sValue) : null)))))));
        return (T)value;
    }
}

