/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbc4;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.javasimon.jdbc4.RegexBasedNormalizerFactory;
import org.javasimon.jdbc4.SimonConnection;
import org.javasimon.jdbc4.SimonConnectionConfiguration;

public final class Driver
implements java.sql.Driver {
    private java.sql.Driver driver;

    @Override
    public Connection connect(String simonUrl, Properties info) throws SQLException {
        if (!this.acceptsURL(simonUrl)) {
            return null;
        }
        SimonConnectionConfiguration url = new SimonConnectionConfiguration(simonUrl);
        this.driver = this.getRealDriver(url, info);
        return new SimonConnection(this.driver.connect(url.getRealUrl(), info), url.getPrefix(), new RegexBasedNormalizerFactory());
    }

    private java.sql.Driver getRealDriver(SimonConnectionConfiguration configuration, Properties info) throws SQLException {
        java.sql.Driver drv = null;
        try {
            drv = DriverManager.getDriver(configuration.getRealUrl());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (drv == null && info != null && info.keySet().contains("simon_real_drv")) {
            drv = this.registerDriver(info.getProperty("simon_real_drv"));
        }
        if (drv == null && configuration.getRealDriver() != null) {
            drv = this.registerDriver(configuration.getRealDriver());
        }
        if (drv == null && configuration.getRealDriver() != null) {
            drv = this.registerDriver(configuration.getRealDriver());
        }
        if (drv == null) {
            throw new SQLException("Real driver is not registered and can't determine real driver class name for registration.");
        }
        return drv;
    }

    private java.sql.Driver registerDriver(String name) throws SQLException {
        try {
            java.sql.Driver d = (java.sql.Driver)Class.forName(name).newInstance();
            DriverManager.registerDriver(d);
            return d;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return SimonConnectionConfiguration.isSimonUrl(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String s, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 4;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.driver.getParentLogger();
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

