/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.spring;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.javasimon.Manager;
import org.javasimon.SimonManager;
import org.javasimon.SwitchingManager;
import org.springframework.beans.factory.InitializingBean;

public class SimonConfigurationBean
implements InitializingBean {
    private Manager simonManager = SimonManager.manager();
    private String configurationPath;

    public Manager getSimonManager() {
        return this.simonManager;
    }

    public void setSimonManager(Manager simonManager) {
        this.simonManager = simonManager;
    }

    public void setNewManager() {
        this.simonManager = new SwitchingManager();
    }

    public void setConfiguration(String configurationPath) throws IOException {
        this.configurationPath = configurationPath;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.configurationPath != null) {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.configurationPath);
            if (is == null) {
                throw new FileNotFoundException(this.configurationPath);
            }
            try (InputStreamReader reader = new InputStreamReader(is);){
                this.simonManager.configuration().readConfig((Reader)reader);
            }
        }
    }
}

