/*
 * Decompiled with CFR 0.152.
 */
package org.javastack.httpbench;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class HttpBench
implements Runnable {
    private static final Map<Option, String> opts = new HashMap<Option, String>();
    private static final ArrayList<String> urls = new ArrayList();
    private final byte[] buf = new byte[2048];
    private final Context ctx;

    public HttpBench(Context ctx) {
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            try {
                this.ctx.start.countDown();
                this.ctx.start.await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            while (this.ctx.total.decrementAndGet() >= 0) {
                boolean isOK = false;
                try {
                    isOK = this.request(null, 0) == 200;
                    (isOK ? this.ctx.requestOk : this.ctx.requestFail).incrementAndGet();
                }
                catch (Exception exception) {
                    (isOK ? this.ctx.requestOk : this.ctx.requestFail).incrementAndGet();
                    continue;
                    catch (Throwable throwable) {
                        (isOK ? this.ctx.requestOk : this.ctx.requestFail).incrementAndGet();
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            this.ctx.stop.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int request(InputStream doOutput, int contentLength) throws IOException {
        int n;
        HttpURLConnection conn = null;
        InputStream urlIs = null;
        OutputStream urlOs = null;
        try {
            conn = (HttpURLConnection)this.ctx.url.openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.setRequestMethod(Context.method);
            conn.setDoInput(true);
            if (doOutput != null) {
                conn.setDoOutput(true);
                if (contentLength > 0) {
                    conn.setFixedLengthStreamingMode(contentLength);
                }
            }
            conn.setConnectTimeout(Context.connectTimeout);
            conn.setReadTimeout(Context.readTimeout);
            if (doOutput != null) {
                conn.setRequestProperty("Content-Type", Context.contentType);
                conn.connect();
                int len = 0;
                urlOs = conn.getOutputStream();
                while ((len = doOutput.read(this.buf)) > 0) {
                    urlOs.write(this.buf, 0, len);
                }
                urlOs.flush();
            } else {
                conn.connect();
            }
            int resCode = conn.getResponseCode();
            try {
                urlIs = conn.getInputStream();
            }
            catch (Exception e) {
                urlIs = conn.getErrorStream();
            }
            int len = 0;
            while ((len = urlIs.read(this.buf)) != -1) {
                this.ctx.htmlTransferred.addAndGet(len);
            }
            n = resCode;
        }
        catch (Throwable throwable) {
            HttpBench.closeQuietly(urlIs);
            HttpBench.closeQuietly(urlOs);
            throw throwable;
        }
        HttpBench.closeQuietly(urlIs);
        HttpBench.closeQuietly(urlOs);
        return n;
    }

    private static final void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void parseOptions(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.isEmpty()) continue;
            if (arg.startsWith("--")) {
                String opt = arg.substring(2);
                if (opt.equals("help")) {
                    HttpBench.printHelp();
                }
                int offEq = opt.indexOf(61);
                String key = null;
                String value = null;
                if (offEq != -1) {
                    key = opt.substring(0, offEq);
                    value = opt.substring(offEq + 1);
                } else {
                    key = opt;
                    value = "";
                }
                Option k = HttpBench.optionOf(key);
                if (k == null) continue;
                opts.put(k, value);
                continue;
            }
            if (!arg.startsWith("http")) {
                throw new RuntimeException("Invalid URL: " + arg);
            }
            urls.add(arg);
        }
        if (urls.isEmpty()) {
            throw new RuntimeException("Not URLs specified");
        }
    }

    private static Option optionOf(String name) {
        try {
            return Option.valueOf(name);
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown option: " + name);
        }
    }

    private static String getOptStr(Option name) {
        String value = opts.get((Object)name);
        if (value == null) {
            value = name.getDef();
        }
        return value;
    }

    private static int getOptInt(Option name) {
        return Integer.parseInt(HttpBench.getOptStr(name));
    }

    private static boolean getOptBool(Option name) {
        String value = HttpBench.getOptStr(name);
        return value != null ? value.isEmpty() : Boolean.parseBoolean(value);
    }

    private static void printHelp() {
        System.out.println(HttpBench.class.getName() + " [<options>] <url> [<url> ...]");
        System.out.println();
        System.out.println("Options:");
        System.out.println();
        for (Option o : Option.values()) {
            System.out.println("--" + (Object)((Object)o) + " (default: " + o.getDef() + ")");
        }
        throw new RuntimeException();
    }

    public static void main(String[] args) throws Throwable {
        try {
            HttpBench.parseOptions(args);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.out.println("ERROR: " + e.getMessage());
                System.out.println();
            }
            try {
                HttpBench.printHelp();
            }
            catch (Exception ign) {
                // empty catch block
            }
            return;
        }
        Context.connectTimeout = HttpBench.getOptInt(Option.connectTimeout);
        Context.readTimeout = HttpBench.getOptInt(Option.readTimeout);
        Context.totalRequest = HttpBench.getOptInt(Option.totalRequest);
        Context.concurrency = HttpBench.getOptInt(Option.concurrency);
        Context.contentType = HttpBench.getOptStr(Option.contentType);
        Context.method = HttpBench.getOptStr(Option.method);
        Context.keepAlive = HttpBench.getOptBool(Option.keepAlive);
        System.setProperty("http.keepAlive", String.valueOf(Context.keepAlive));
        System.setProperty("http.maxConnections", String.valueOf(Context.concurrency));
        for (int i = 0; i < urls.size(); ++i) {
            String url = urls.get(i);
            Context ctx = new Context(new URL(url));
            for (int j = 0; j < Context.concurrency; ++j) {
                new Thread(new HttpBench(ctx)).start();
            }
            ctx.start.countDown();
            ctx.start.await();
            long ts = System.currentTimeMillis();
            ctx.stop.await();
            float time = (float)(System.currentTimeMillis() - ts) / 1000.0f;
            String reqSec = String.format(Locale.US, "%.2f", Float.valueOf((float)Context.totalRequest / Math.max(time, 1.0f)));
            System.out.println("URL:                    " + ctx.url);
            System.out.println("Concurrency Level:      " + Context.concurrency);
            System.out.println("Use KeepAlive:          " + Context.keepAlive);
            System.out.println("Time taken for tests:   " + time + " seconds");
            System.out.println("Complete requests:      " + ctx.requestOk.get());
            System.out.println("Failed requests:        " + ctx.requestFail.get());
            System.out.println("HTML transferred:       " + ctx.htmlTransferred.get() + " bytes");
            System.out.println("Requests per second:    " + reqSec + " [#/sec] (mean)");
        }
    }

    private static class Context {
        static int connectTimeout;
        static int readTimeout;
        static int totalRequest;
        static int concurrency;
        static String contentType;
        static String method;
        static boolean keepAlive;
        final AtomicInteger total;
        final AtomicInteger requestOk;
        final AtomicInteger requestFail;
        final AtomicLong htmlTransferred;
        final CountDownLatch start;
        final CountDownLatch stop;
        final URL url;

        Context(URL url) {
            this.url = url;
            this.requestOk = new AtomicInteger();
            this.requestFail = new AtomicInteger();
            this.htmlTransferred = new AtomicLong();
            this.total = new AtomicInteger(totalRequest);
            this.start = new CountDownLatch(concurrency + 1);
            this.stop = new CountDownLatch(concurrency);
        }
    }

    private static enum Option {
        connectTimeout(30000),
        readTimeout(30000),
        totalRequest(1),
        concurrency(1),
        contentType("text/plain"),
        method("GET"),
        keepAlive(false);

        final String def;

        private Option(String def) {
            this.def = def;
        }

        private Option(int def) {
            this.def = String.valueOf(def);
        }

        private Option(boolean def) {
            this.def = String.valueOf(def);
        }

        public String getDef() {
            return this.def;
        }
    }
}

