/*
 * Decompiled with CFR 0.152.
 */
package org.javastack.log4j.simplejson;

public class EncoderJSON {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static final String escapeJSON(CharSequence in) {
        StringBuilder sb = new StringBuilder(in.length() + 256);
        EncoderJSON.escapeJSON(in, sb);
        return sb.toString();
    }

    public static final void escapeJSON(CharSequence in, StringBuilder sb) {
        int len = in.length();
        block10: for (int i = 0; i < len; ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        sb.append("\\u");
                        sb.append(EncoderJSON.toHex(c >> 12));
                        sb.append(EncoderJSON.toHex(c >> 8));
                        sb.append(EncoderJSON.toHex(c >> 4));
                        sb.append(EncoderJSON.toHex(c));
                        continue block10;
                    }
                    sb.append(c);
                }
            }
        }
    }
}

