/*
 * Decompiled with CFR 0.152.
 */
package org.javastack.log4j.simplejson;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.MapLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.javastack.log4j.simplejson.EncoderJSON;

@Plugin(name="SimpleJSONLayout", category="Core", elementType="layout", printObject=true)
public final class SimpleJSONLayout
extends AbstractStringLayout {
    private static final String CONTENT_TYPE = "application/json";
    private static final String DEFAULT_HEADER = "[";
    private static final String DEFAULT_FOOTER = "]";
    private static final String DEFAULT_EOL = "\r\n";
    private static final String COMPACT_EOL = "";
    public static final int LAYOUT_VERSION = 1;
    private final long layoutStartTime;
    private final AtomicLong layoutSequence;
    private final Interpolator interpolator;
    private final KeyValuePair[] additionalFields;
    private final boolean locationInfo;
    private final boolean properties;
    private final boolean complete;
    private final String eol;

    protected SimpleJSONLayout(Configuration config, boolean locationInfo, boolean properties, boolean complete, boolean eventEol, String headerPattern, String footerPattern, Charset charset, KeyValuePair[] additionalFields) {
        super(config, charset, PatternLayout.newSerializerBuilder().setConfiguration(config).setReplace(null).setPattern(headerPattern).setDefaultPattern(DEFAULT_HEADER).setPatternSelector(null).setAlwaysWriteExceptions(false).setNoConsoleNoAnsi(false).build(), PatternLayout.newSerializerBuilder().setConfiguration(config).setReplace(null).setPattern(footerPattern).setDefaultPattern(DEFAULT_FOOTER).setPatternSelector(null).setAlwaysWriteExceptions(false).setNoConsoleNoAnsi(false).build());
        this.locationInfo = locationInfo;
        this.properties = properties;
        this.complete = complete;
        this.additionalFields = additionalFields;
        this.layoutStartTime = System.currentTimeMillis();
        this.layoutSequence = new AtomicLong();
        this.interpolator = new Interpolator((StrLookup)new MapLookup(this.getConfiguration().getProperties()), this.getConfiguration().getPluginPackages());
        this.eol = !eventEol ? COMPACT_EOL : DEFAULT_EOL;
    }

    public Map<String, String> getContentFormat() {
        Map result = super.getContentFormat();
        result.put("version", String.valueOf(1));
        return result;
    }

    public String getContentType() {
        return "application/json; charset=" + this.getCharset();
    }

    public byte[] getHeader() {
        if (!this.complete) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String str = this.serializeToString(this.getHeaderSerializer());
        if (str != null) {
            buf.append(str);
        }
        buf.append(this.eol);
        return this.getBytes(buf.toString());
    }

    public byte[] getFooter() {
        if (!this.complete) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.eol);
        String str = this.serializeToString(this.getFooterSerializer());
        if (str != null) {
            buf.append(str);
        }
        buf.append(this.eol);
        return this.getBytes(buf.toString());
    }

    public String toSerializable(LogEvent event) {
        try {
            String string = this.format(SimpleJSONLayout.convertMutableToLog4jEvent(event));
            return string;
        }
        finally {
            this.markEvent();
        }
    }

    private static LogEvent convertMutableToLog4jEvent(LogEvent event) {
        return event instanceof MutableLogEvent ? ((MutableLogEvent)event).createMemento() : event;
    }

    private final String format(LogEvent event) {
        StringBuilder sb = SimpleJSONLayout.getStringBuilder();
        if (this.complete && this.eventCount > 0L) {
            sb.append(", ");
        }
        sb.append('{');
        this.json(sb, "layout.version", 1L);
        this.json(sb, "layout.start", this.layoutStartTime);
        this.json(sb, "layout.sequence", this.layoutSequence.incrementAndGet());
        this.json(sb, "timestamp", event.getTimeMillis());
        this.json(sb, "thread", event.getThreadName());
        this.json(sb, "threadId", event.getThreadId());
        this.json(sb, "level", event.getLevel().toString());
        this.json(sb, "logger", event.getLoggerName());
        if (this.locationInfo) {
            StackTraceElement source = event.getSource();
            this.json(sb, "source");
            sb.append('{');
            this.json(sb, "class", source.getClassName());
            this.json(sb, "method", source.getMethodName());
            this.json(sb, "file", source.getFileName());
            this.json(sb, "line", source.getLineNumber());
            sb.setLength(sb.length() - 1);
            sb.append('}').append(',');
        }
        if (this.properties) {
            if (!event.getContextStack().isEmpty()) {
                this.json(sb, "ndc", event.getContextStack().asList());
            }
            if (!event.getContextData().isEmpty()) {
                this.json(sb, "mdc", event.getContextData().toMap());
            }
        }
        for (int i = 0; i < this.additionalFields.length; ++i) {
            KeyValuePair kv = this.additionalFields[i];
            String key = kv.getKey();
            String value = kv.getValue();
            String iv = this.interpolator.lookup(event, value);
            if (iv == null) continue;
            this.json(sb, key != null ? key : value, iv);
        }
        this.json(sb, "msg", event.getMessage().getFormattedMessage());
        if (event.getThrownProxy() != null) {
            String stackTrace;
            String exMsg;
            ThrowableProxy throwableInfo = event.getThrownProxy();
            Throwable t = throwableInfo.getThrowable();
            String exClass = t.getClass().getCanonicalName();
            if (exClass != null) {
                this.json(sb, "exception", exClass);
            }
            if ((exMsg = t.getMessage()) != null) {
                this.json(sb, "cause", exMsg);
            }
            if ((stackTrace = throwableInfo.getExtendedStackTraceAsString(COMPACT_EOL)) != null) {
                this.json(sb, "stacktrace", stackTrace);
            }
        }
        sb.setLength(sb.length() - 1);
        sb.append('}').append(this.eol);
        return sb.toString();
    }

    private final StringBuilder json(StringBuilder sb, String key, List<String> value) {
        this.json(sb, key).append('[');
        if (value != null && value.size() > 0) {
            for (int i = 0; i < value.size(); ++i) {
                sb.append('\"');
                EncoderJSON.escapeJSON(value.get(i), sb);
                sb.append('\"').append(',');
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.append(']').append(',');
    }

    private final StringBuilder json(StringBuilder sb, String key, Map<?, ?> m) {
        this.json(sb, key).append('{');
        if (m != null && !m.isEmpty()) {
            for (Map.Entry<?, ?> e : m.entrySet()) {
                String sk = e.getKey() != null ? e.getKey().toString() : COMPACT_EOL;
                String sv = e.getValue() != null ? e.getValue().toString() : COMPACT_EOL;
                this.json(sb, sk, sv);
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.append('}').append(',');
    }

    private final StringBuilder json(StringBuilder sb, String key) {
        sb.append('\"');
        if (key != null) {
            EncoderJSON.escapeJSON(key, sb);
        }
        return sb.append('\"').append(':');
    }

    private final StringBuilder json(StringBuilder sb, String key, String value) {
        this.json(sb, key).append('\"');
        if (value != null) {
            EncoderJSON.escapeJSON(value, sb);
        }
        return sb.append('\"').append(',');
    }

    private final StringBuilder json(StringBuilder sb, String key, long value) {
        return this.json(sb, key).append(value).append(',');
    }

    @PluginFactory
    public static SimpleJSONLayout createLayout(@PluginConfiguration Configuration config, @PluginAttribute(value="locationInfo", defaultBoolean=false) boolean locationInfo, @PluginAttribute(value="properties", defaultBoolean=true) boolean properties, @PluginAttribute(value="complete", defaultBoolean=false) boolean complete, @PluginAttribute(value="eventEol", defaultBoolean=true) boolean eventEol, @PluginAttribute(value="header", defaultString="[") String headerPattern, @PluginAttribute(value="footer", defaultString="]") String footerPattern, @PluginAttribute(value="charset", defaultString="US-ASCII") Charset charset, @PluginElement(value="AdditionalField") KeyValuePair[] additionalFields) {
        return new SimpleJSONLayout(config, locationInfo, properties, complete, eventEol, headerPattern, footerPattern, charset, additionalFields);
    }
}

