/*
 * Decompiled with CFR 0.152.
 */
package org.javastack.log4j.simplejson;

import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.javastack.log4j.simplejson.EncoderJSON;

@Plugin(name="json", category="Converter")
@ConverterKeys(value={"json"})
public final class SimpleJSONPatternConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;

    private SimpleJSONPatternConverter(List<PatternFormatter> formatters) {
        super("json", "json");
        this.formatters = formatters;
    }

    public static SimpleJSONPatternConverter newInstance(Configuration config, String[] options) {
        if (options.length != 1) {
            LOGGER.error("Incorrect number of options on json. Expected 1, received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on json");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser((Configuration)config);
        List formatters = parser.parse(options[0]);
        return new SimpleJSONPatternConverter(formatters);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        StringBuilder buf = new StringBuilder();
        for (PatternFormatter formatter : this.formatters) {
            formatter.format(event, buf);
        }
        EncoderJSON.escapeJSON(buf, toAppendTo);
    }
}

