/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.validation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.output.OutputUnit;
import jakarta.persistence.EntityManager;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.util.ValidationEventCollector;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.hibernate.Session;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.ivoa.vodml.ModelManagement;
import org.ivoa.vodml.VodmlModel;
import org.ivoa.vodml.jpa.JPAManipulationsForObjectType;
import org.ivoa.vodml.validation.JSONValidator;
import org.ivoa.vodml.validation.XMLValidator;

public abstract class AbstractBaseValidation {
    protected <T> RoundTripResult<T> roundTripJSON(VodmlModel<T> m) throws JsonProcessingException {
        T model = m.management().theModel();
        if (m.management().hasReferences()) {
            m.processReferences();
        }
        Class<?> clazz = model.getClass();
        ObjectMapper mapper = m.management().jsonMapper();
        String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(model);
        System.out.println("JSON output");
        System.out.println(json);
        JSONValidator jsonValidator = new JSONValidator(m.management());
        OutputUnit vresult = jsonValidator.validate(json);
        if (!vresult.isValid()) {
            System.err.println(vresult.toString());
        }
        Object retval = mapper.readValue(json, clazz);
        return new RoundTripResult<Object>(vresult.isValid(), retval);
    }

    protected <T extends VodmlModel<T>> RoundTripResult<T> roundtripXML(VodmlModel<T> vodmlModel) throws ParserConfigurationException, JAXBException, PropertyException, TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        VodmlModel model = (VodmlModel)vodmlModel.management().theModel();
        if (vodmlModel.management().hasReferences()) {
            vodmlModel.processReferences();
        }
        Class<?> clazz = model.getClass();
        JAXBContext jc = vodmlModel.management().contextFactory();
        StringWriter sw = new StringWriter();
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)model, (Writer)sw);
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter sw2 = new StringWriter();
        StreamResult result = new StreamResult(sw2);
        trans.transform(new StreamSource(new StringReader(sw.toString())), result);
        String xmlOutput = sw2.toString();
        System.out.println(xmlOutput);
        XMLValidator xmlValidator = new XMLValidator(vodmlModel.management());
        XMLValidator.ValidationResult validation = xmlValidator.validate(xmlOutput);
        if (!validation.isOk) {
            validation.printValidationErrors(System.err);
        }
        Unmarshaller um = jc.createUnmarshaller();
        ValidationEventCollector vc = new ValidationEventCollector();
        um.setEventHandler((ValidationEventHandler)vc);
        JAXBElement el = um.unmarshal((Source)new StreamSource(new StringReader(xmlOutput)), clazz);
        if (vc.hasEvents()) {
            for (ValidationEvent err : vc.getEvents()) {
                System.err.println(err.getMessage());
            }
        }
        VodmlModel modelin = (VodmlModel)el.getValue();
        return new RoundTripResult<VodmlModel>(!vc.hasEvents() & validation.isOk, modelin);
    }

    protected <M, I, T extends JPAManipulationsForObjectType<I>> RoundTripResult<T> roundtripRDB(ModelManagement<M> modelManagement, T entity) {
        EntityManager em = this.setupH2Db(modelManagement.pu_name(), modelManagement.description().allClassNames());
        em.getTransaction().begin();
        modelManagement.persistRefs(em);
        em.persist(entity);
        em.getTransaction().commit();
        I id = entity.getId();
        String dumpfile = this.setDbDumpFile();
        if (dumpfile != null) {
            this.dumpDbData(em, dumpfile);
        }
        em.clear();
        em.getEntityManagerFactory().getCache().evictAll();
        JPAManipulationsForObjectType r = (JPAManipulationsForObjectType)em.createNamedQuery(entity.getClass().getSimpleName() + ".findById", entity.getClass()).setParameter("id", id).getSingleResult();
        return new RoundTripResult<JPAManipulationsForObjectType>(true, r);
    }

    protected EntityManager setupH2Db(String puname, List<String> classNames) {
        HibernatePersistenceUnitInfo persistenceUnitInfo = new HibernatePersistenceUnitInfo(puname, classNames);
        HashMap configuration = new HashMap();
        return new EntityManagerFactoryBuilderImpl((PersistenceUnitDescriptor)new PersistenceUnitInfoDescriptor((PersistenceUnitInfo)persistenceUnitInfo), configuration).build().createEntityManager();
    }

    protected <T> XMLValidator.ValidationResult validateModel(VodmlModel<T> m) throws JAXBException {
        XMLValidator v = new XMLValidator(m.management());
        return v.validateObject(m.management().theModel());
    }

    protected void dumpDbData(EntityManager em, String filename) {
        Session sess = (Session)em.unwrap(Session.class);
        sess.doWork(conn -> {
            PreparedStatement ps = conn.prepareStatement("SCRIPT TO ?");
            ps.setString(1, filename);
            ps.execute();
        });
    }

    protected String setDbDumpFile() {
        return null;
    }

    public static class RoundTripResult<T> {
        public final boolean isValid;
        public final T retval;

        RoundTripResult(boolean isValid, T retval) {
            this.isValid = isValid;
            this.retval = retval;
        }
    }

    private static class HibernatePersistenceUnitInfo
    implements PersistenceUnitInfo {
        public static String JPA_VERSION = "2.1";
        private String persistenceUnitName;
        private PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        private List<String> managedClassNames;
        private List<String> mappingFileNames = new ArrayList<String>();
        private Properties properties;
        private DataSource jtaDataSource;
        private DataSource nonjtaDataSource;
        private List<ClassTransformer> transformers = new ArrayList<ClassTransformer>();

        public HibernatePersistenceUnitInfo(String persistenceUnitName, List<String> managedClassNames) {
            this.persistenceUnitName = persistenceUnitName;
            this.managedClassNames = managedClassNames;
            this.properties = new Properties();
            this.properties.put("jakarta.persistence.jdbc.url", "jdbc:h2:mem:" + persistenceUnitName + ";DB_CLOSE_DELAY=-1");
            this.properties.put("jakarta.persistence.jdbc.driver", "org.h2.Driver");
            this.properties.put("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
            this.properties.put("jakarta.persistence.schema-generation.scripts.create-target", "test.sql");
            this.properties.put("jakarta.persistence.schema-generation.scripts.drop-target", "test-drop.sql");
            this.properties.put("hibernate.hbm2ddl.schema-generation.script.append", "false");
            this.properties.put("jakarta.persistence.create-database-schemas", "true");
            this.properties.put("jakarta.persistence.schema-generation.create-source", "metadata");
            this.properties.put("jakarta.persistence.schema-generation.database.action", "drop-and-create");
            this.properties.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
            this.properties.put("jakarta.persistence.jdbc.user", "");
        }

        public String getPersistenceUnitName() {
            return this.persistenceUnitName;
        }

        public String getPersistenceProviderClassName() {
            return "org.hibernate.jpa.HibernatePersistenceProvider";
        }

        public PersistenceUnitTransactionType getTransactionType() {
            return this.transactionType;
        }

        public DataSource getJtaDataSource() {
            return null;
        }

        public DataSource getNonJtaDataSource() {
            return null;
        }

        public List<String> getMappingFileNames() {
            return this.mappingFileNames;
        }

        public List<URL> getJarFileUrls() {
            return Collections.emptyList();
        }

        public URL getPersistenceUnitRootUrl() {
            return null;
        }

        public List<String> getManagedClassNames() {
            return this.managedClassNames;
        }

        public boolean excludeUnlistedClasses() {
            return true;
        }

        public SharedCacheMode getSharedCacheMode() {
            return SharedCacheMode.ALL;
        }

        public ValidationMode getValidationMode() {
            return ValidationMode.AUTO;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public String getPersistenceXMLSchemaVersion() {
            return JPA_VERSION;
        }

        public ClassLoader getClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }

        public void addTransformer(ClassTransformer transformer) {
            throw new UnsupportedOperationException("PersistenceUnitInfo.addTransformer() not implemented");
        }

        public ClassLoader getNewTempClassLoader() {
            return null;
        }
    }
}

