/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.vocabularies;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Term {
    private final String term;
    private final String label;
    private final String description;
    private final boolean preliminary;
    private final boolean deprecated;
    private List<Term> wider = new ArrayList<Term>();
    private List<Term> narrower = new ArrayList<Term>();
    private Term parent;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Term(@JsonProperty(value="term") String term, @JsonProperty(value="label") String label, @JsonProperty(value="description") String description, @JsonProperty(value="preliminary") String preliminary, @JsonProperty(value="deprecated") String deprecated) {
        this.term = term;
        this.label = label;
        this.description = description;
        this.preliminary = preliminary != null;
        this.deprecated = deprecated != null;
    }

    @JsonProperty
    public String getTerm() {
        return this.term;
    }

    @JsonProperty
    public String getLabel() {
        return this.label;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public boolean isPreliminary() {
        return this.preliminary;
    }

    @JsonProperty
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Term term1 = (Term)o;
        return Objects.equals(this.term, term1.term);
    }

    public int hashCode() {
        return Objects.hashCode(this.term);
    }

    public String toString() {
        return "Term{term='" + this.term + "', label='" + this.label + "', description='" + this.description + "', preliminary=" + this.preliminary + ", deprecated=" + this.deprecated + "}";
    }

    public boolean hasWiderTerm(Term t) {
        return this.wider.contains(t);
    }

    public void addWider(Term wider) {
        this.wider.add(wider);
    }

    public void addNarrower(Term term) {
        this.narrower.add(term);
    }

    public boolean hasNarrowerTerm(Term term) {
        return this.narrower.contains(term);
    }

    public void addParent(Term parent) {
        this.parent = parent;
    }

    public Term getParent() {
        return this.parent;
    }
}

