/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.vocabularies;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ivoa.vodml.vocabularies.Term;

public class Vocabulary {
    Map<String, Term> terms = new HashMap<String, Term>();
    private String url;
    private boolean loadSuccessful;

    public Vocabulary(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isLoadSuccessful() {
        return this.loadSuccessful;
    }

    public static Vocabulary loadRemote(String url) {
        Vocabulary vocabulary = new Vocabulary(url);
        try {
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Accept", "application/x-desise+json").GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("cannot load vocabulary : " + response.statusCode());
            }
            Vocabulary.loadInternal(response.body(), vocabulary);
        }
        catch (IOException | InterruptedException e) {
            System.err.println("cannot load vocabulary " + url + " " + e.getMessage());
        }
        return vocabulary;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vocabulary loadLocal(String url) {
        Vocabulary vocabulary = new Vocabulary(url);
        ClassLoader classLoader = Vocabulary.class.getClassLoader();
        try (InputStream is = classLoader.getResourceAsStream(URLEncoder.encode(url, StandardCharsets.UTF_8));){
            if (is == null) {
                System.err.println("cannot load vocabulary " + url);
                Vocabulary vocabulary2 = vocabulary;
                return vocabulary2;
            }
            try (InputStreamReader isr = new InputStreamReader(is);
                 BufferedReader reader = new BufferedReader(isr);){
                Vocabulary.loadInternal(reader.lines().collect(Collectors.joining(System.lineSeparator())), vocabulary);
                return vocabulary;
            }
            catch (IOException e) {
                throw new RuntimeException("cannot load vocabulary " + url, e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("cannot load vocabulary " + url, e);
        }
    }

    private static void loadInternal(String desise, Vocabulary vocabulary) throws JsonProcessingException {
        ObjectNode term;
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode rootNode = objectMapper.readTree(desise);
        for (Map.Entry entry : rootNode.get("terms").properties()) {
            term = (ObjectNode)entry.getValue();
            term.put("term", (String)entry.getKey());
            vocabulary.terms.put((String)entry.getKey(), (Term)objectMapper.treeToValue((TreeNode)term, Term.class));
        }
        for (Map.Entry entry : rootNode.get("terms").properties()) {
            term = (ObjectNode)entry.getValue();
            Term voterm = vocabulary.terms.get(entry.getKey());
            if (term.has("wider")) {
                term.get("wider").spliterator().forEachRemaining(e -> voterm.addWider(vocabulary.terms.get(e.textValue())));
            }
            if (term.has("narrower")) {
                term.get("narrower").spliterator().forEachRemaining(e -> voterm.addNarrower(vocabulary.terms.get(e.textValue())));
            }
            if (!term.has("parent")) continue;
            voterm.addParent(vocabulary.terms.get(term.get("parent").textValue()));
        }
        vocabulary.loadSuccessful = true;
    }

    public boolean hasTerm(String term) {
        return this.loadSuccessful ? this.terms.containsKey(term) : true;
    }

    public Optional<Term> getTerm(String term) {
        return Optional.ofNullable(this.terms.get(term));
    }
}

