/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.jpa;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class AttributeConverters {

    public static class BooleanListConverter
    extends ListConcatenatedType<Boolean> {
        public List<Boolean> deepCopy(List<Boolean> value) {
            return value.stream().map(Boolean::valueOf).collect(Collectors.toList());
        }

        public List<Boolean> nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
            String dbData = rs.getString(position);
            return dbData != null ? Stream.of(dbData.split(this.regexp)).map(Boolean::parseBoolean).toList() : new ArrayList<Boolean>();
        }
    }

    public static class DoubleListConverter
    extends ListConcatenatedType<Double> {
        public List<Double> deepCopy(List<Double> value) {
            return value.stream().map(Double::valueOf).collect(Collectors.toList());
        }

        public List<Double> nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
            String dbData = rs.getString(position);
            return dbData != null ? Stream.of(dbData.split(this.regexp)).map(Double::parseDouble).toList() : new ArrayList<Double>();
        }
    }

    public static class IntListConverter
    extends ListConcatenatedType<Integer> {
        public List<Integer> deepCopy(List<Integer> value) {
            return value.stream().map(Integer::valueOf).collect(Collectors.toList());
        }

        public List<Integer> nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
            String dbData = rs.getString(position);
            return dbData != null ? Stream.of(dbData.split(this.regexp)).map(Integer::parseInt).toList() : new ArrayList<Integer>();
        }
    }

    public static class StringListConverter
    extends ListConcatenatedType<String> {
        public List<String> nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
            String dbData = rs.getString(position);
            return dbData != null ? Arrays.asList(dbData.split(this.regexp)) : new ArrayList<String>();
        }

        public List<String> deepCopy(List<String> value) {
            return value != null ? value.stream().map(String::new).collect(Collectors.toList()) : null;
        }
    }

    public static abstract class ListConcatenatedType<T>
    implements UserType<List<T>>,
    ParameterizedType {
        protected String concatenationChar;
        protected String regexp;

        public void setParameterValues(Properties parameters) {
            String sep = parameters.getProperty("separator");
            if (sep != null) {
                this.concatenationChar = sep;
                this.regexp = this.concatenationChar.matches("[|+*=\\-]") ? "\\" + this.concatenationChar : this.concatenationChar;
            } else {
                this.concatenationChar = ";";
                this.regexp = ";";
            }
        }

        public int getSqlType() {
            return 12;
        }

        public Class<List<T>> returnedClass() {
            return List.class;
        }

        public boolean equals(List<T> x, List<T> y) {
            return Objects.equals(x, y);
        }

        public int hashCode(List<T> x) {
            return Objects.hashCode(x);
        }

        public void nullSafeSet(PreparedStatement st, List<T> value, int index, SharedSessionContractImplementor session) throws SQLException {
            if (value == null || value.isEmpty()) {
                st.setNull(index, 12);
            } else {
                String dbval = value.stream().map(Object::toString).collect(Collectors.joining(this.concatenationChar));
                st.setString(index, dbval);
            }
        }

        public boolean isMutable() {
            return false;
        }

        public Serializable disassemble(List<T> value) {
            return null;
        }

        public List<T> assemble(Serializable cached, Object owner) {
            return null;
        }
    }
}

