/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.validation;

import com.networknt.schema.InputFormat;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.OutputFormat;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.output.OutputUnit;
import org.ivoa.vodml.ModelManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONValidator {
    private static final Logger logger = LoggerFactory.getLogger(JSONValidator.class);
    private final ModelManagement<?> modelManagement;
    private final SchemaValidatorsConfig config;
    private JsonSchemaFactory jsonSchemaFactory;

    public JSONValidator(ModelManagement<?> modelManagement) {
        this.modelManagement = modelManagement;
        this.jsonSchemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012, builder -> builder.schemaMappers(schemaMappers -> schemaMappers.mapPrefix("https://ivoa.net/dm/", "classpath:")));
        SchemaValidatorsConfig.Builder builder2 = SchemaValidatorsConfig.builder();
        this.config = builder2.build();
    }

    public OutputUnit validate(String json) {
        JsonSchema schema = this.jsonSchemaFactory.getSchema(SchemaLocation.of((String)this.modelManagement.description().jsonSchema()), this.config);
        OutputUnit ou = (OutputUnit)schema.validate(json, InputFormat.JSON, (OutputFormat)OutputFormat.HIERARCHICAL, executionContext -> executionContext.getExecutionConfig().setFormatAssertionsEnabled(Boolean.valueOf(true)));
        return ou;
    }
}

