/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.validation;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.util.JAXBSource;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.ivoa.vodml.ModelManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xmlresolver.CatalogManager;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.XMLResolver;
import org.xmlresolver.XMLResolverConfiguration;
import org.xmlresolver.catalog.entry.EntryCatalog;

public class XMLValidator {
    private static final Logger logger = LoggerFactory.getLogger(XMLValidator.class);
    private final String schemaCat;
    private JAXBContext jc;
    private final Source[] schemaFiles;
    protected Map<ErrorKind, List<ErrorDescription>> errorMap;

    public XMLValidator(ModelManagement<?> modelManagement) {
        this.schemaFiles = (Source[])modelManagement.description().schemaMap().entrySet().stream().map(s -> new StreamSource(this.getClass().getResourceAsStream("/" + (String)s.getValue()), (String)s.getKey())).toArray(Source[]::new);
        this.schemaCat = XMLValidator.makeCatalogue(modelManagement.description().schemaMap());
        try {
            this.jc = modelManagement.contextFactory();
        }
        catch (JAXBException e) {
            this.jc = null;
            logger.error("unable to create a model validator", (Throwable)e);
        }
    }

    public XMLValidator() {
        this.schemaFiles = new Source[]{new StreamSource(this.getClass().getResourceAsStream("/xsd/vo-dml-v1.0.xsd"))};
        StringWriter writer = new StringWriter();
        writer.write("<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">\n");
        writer.write("</catalog>");
        this.schemaCat = writer.toString();
    }

    private static String makeCatalogue(Map<String, String> schemaMap) {
        StringWriter writer = new StringWriter();
        writer.write("<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">\n");
        schemaMap.forEach((k, v) -> {
            writer.append("<uri name=\"");
            writer.append((CharSequence)k);
            writer.append("\" uri=\"classpath:/");
            writer.append((CharSequence)v);
            writer.append("\"/>\n");
        });
        writer.write("</catalog>");
        return writer.toString();
    }

    public <T> ValidationResult validateObject(T p) {
        try {
            JAXBSource source = new JAXBSource(this.jc, p);
            this.validateJAXB(source);
        }
        catch (JAXBException e) {
            ErrorDescription d = new ErrorDescription(new RuntimeException(e));
            XMLValidator.put(this.errorMap, d.kind, d);
        }
        return new ValidationResult(this.errorMap.isEmpty(), this.errorMap);
    }

    public ValidationResult validate(File file) {
        return this.validate(new StreamSource(file));
    }

    public ValidationResult validate(String s) {
        return this.validate(new StreamSource(new StringReader(s)));
    }

    public ValidationResult validate(Source source) {
        try {
            Validator validator = this.initValidator();
            validator.validate(source);
        }
        catch (SAXException e) {
            ErrorDescription d = new ErrorDescription(e);
            XMLValidator.put(this.errorMap, d.kind, d);
        }
        catch (IOException e) {
            ErrorDescription d = new ErrorDescription(new RuntimeException(e));
            XMLValidator.put(this.errorMap, d.kind, d);
        }
        return new ValidationResult(this.errorMap.isEmpty(), this.errorMap);
    }

    ValidationResult validateJAXB(JAXBSource source) {
        return this.validate((Source)source);
    }

    private Validator initValidator() throws SAXException {
        this.errorMap = new HashMap<ErrorKind, List<ErrorDescription>>();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver((LSResourceResolver)this.makeXMLResolver().getLSResourceResolver());
        Schema schema = schemaFactory.newSchema(this.schemaFiles);
        Validator validator = schema.newValidator();
        validator.setErrorHandler(new SimpleErrorHandler());
        return validator;
    }

    XMLResolver makeXMLResolver() {
        XMLResolverConfiguration config = new XMLResolverConfiguration();
        config.setFeature(ResolverFeature.DEFAULT_LOGGER_LOG_LEVEL, (Object)"info");
        config.setFeature(ResolverFeature.ACCESS_EXTERNAL_DOCUMENT, (Object)"all");
        config.setFeature(ResolverFeature.THROW_URI_EXCEPTIONS, (Object)true);
        config.setFeature(ResolverFeature.ALWAYS_RESOLVE, (Object)true);
        config.setFeature(ResolverFeature.PREFER_PUBLIC, (Object)false);
        config.setFeature(ResolverFeature.CLASSPATH_CATALOGS, (Object)true);
        config.setFeature(ResolverFeature.CLASSLOADER, (Object)ClassLoader.getSystemClassLoader());
        CatalogManager manager = (CatalogManager)config.getFeature(ResolverFeature.CATALOG_MANAGER);
        URI caturi = URI.create("https://ivoa.net/vodml/catalog.xml");
        config.addCatalog(caturi.toString());
        EntryCatalog cat = manager.loadCatalog(caturi, new InputSource(new StringReader(this.schemaCat)));
        XMLResolver resolver = new XMLResolver((ResolverConfiguration)config);
        return resolver;
    }

    private static <KEY, VALUE> void put(Map<KEY, List<VALUE>> map, KEY key, VALUE value) {
        map.computeIfAbsent(key, k -> new ArrayList()).add(value);
    }

    public static class ValidationResult {
        public final boolean isOk;
        private final Map<ErrorKind, List<ErrorDescription>> errorMap;

        ValidationResult(boolean isOk, Map<ErrorKind, List<ErrorDescription>> errorMap) {
            this.isOk = isOk;
            this.errorMap = new HashMap<ErrorKind, List<ErrorDescription>>(errorMap);
        }

        public void printValidationErrors(PrintStream printStream) {
            this.errorMap.forEach((kind, errors) -> errors.stream().forEach(printStream::println));
        }

        public void printValidationErrors(Writer writer) {
            this.errorMap.forEach((kind, errors) -> errors.stream().forEach(errorDescription -> {
                try {
                    writer.write(errorDescription.toString());
                    writer.write(System.lineSeparator());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
    }

    private class ErrorDescription {
        String desc;
        ErrorKind kind;
        int line;
        int column;

        ErrorDescription(ErrorKind kind, SAXParseException e) {
            this.desc = e.getMessage();
            this.kind = kind;
            this.line = e.getLineNumber();
            this.column = e.getColumnNumber();
        }

        ErrorDescription(SAXException e) {
            this.desc = e.getMessage();
            this.kind = ErrorKind.Sax;
            this.line = 0;
            this.column = 0;
        }

        ErrorDescription(RuntimeException e) {
            this.desc = e.getCause().getMessage();
            this.kind = ErrorKind.Unknown;
            this.line = 0;
            this.column = 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Validation ");
            builder.append((Object)this.kind);
            builder.append(" ").append(this.desc);
            if (this.line > 0) {
                builder.append(" line=");
                builder.append(this.line);
                if (this.column > 0) {
                    builder.append(", column=");
                    builder.append(this.column);
                }
            }
            return builder.toString();
        }
    }

    public static enum ErrorKind {
        Unknown,
        Warning,
        Error,
        FatalError,
        Sax;

    }

    private class SimpleErrorHandler
    implements ErrorHandler {
        private SimpleErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            ErrorKind kind = ErrorKind.Warning;
            ErrorDescription err = new ErrorDescription(kind, exception);
            logger.trace(err.toString());
            XMLValidator.put(XMLValidator.this.errorMap, kind, err);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            ErrorKind kind = ErrorKind.Warning;
            ErrorDescription err = new ErrorDescription(kind, exception);
            logger.trace(err.toString());
            XMLValidator.put(XMLValidator.this.errorMap, kind, err);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            ErrorKind kind = ErrorKind.Warning;
            ErrorDescription err = new ErrorDescription(kind, exception);
            logger.trace(err.toString());
            XMLValidator.put(XMLValidator.this.errorMap, kind, err);
        }
    }
}

