/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.vodsl.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import net.ivoa.vodsl.services.VodslGrammarAccess;
import net.ivoa.vodsl.vodsl.DataType;
import net.ivoa.vodsl.vodsl.IncludeDeclaration;
import net.ivoa.vodsl.vodsl.ModelDeclaration;
import net.ivoa.vodsl.vodsl.PackageDeclaration;
import net.ivoa.vodsl.vodsl.ReferableElement;
import net.ivoa.vodsl.vodsl.Role;
import net.ivoa.vodsl.vodsl.VoDataModel;
import net.ivoa.vodsl.vodsl.VodslPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class VodslFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private VodslGrammarAccess _vodslGrammarAccess;

    protected void _format(VoDataModel voDataModel, @Extension IFormattableDocument document) {
        document.format((Object)voDataModel.getModel());
        EList<IncludeDeclaration> _includes = voDataModel.getIncludes();
        for (IncludeDeclaration includes : _includes) {
            document.format((Object)includes);
        }
        Procedures.Procedure1 _function = it -> {
            it.setNewLines(2, 2, 4);
            it.highPriority();
        };
        document.prepend((EObject)((ReferableElement)IterableExtensions.head(voDataModel.getElements())), _function);
        EList<ReferableElement> _elements = voDataModel.getElements();
        for (ReferableElement elements : _elements) {
            document.format((Object)elements);
        }
    }

    protected void _format(ModelDeclaration m, @Extension IFormattableDocument doc) {
        List _keywords = this.textRegionExtensions.regionFor((EObject)m).keywords(new String[]{"author"});
        for (ISemanticRegion k : _keywords) {
            Procedures.Procedure1 _function = it -> it.newLine();
            doc.prepend(k, _function);
        }
    }

    protected void _format(IncludeDeclaration m, @Extension IFormattableDocument doc) {
        Procedures.Procedure1 _function = it -> it.setNewLines(1, 1, 2);
        doc.prepend(this.textRegionExtensions.regionFor((EObject)m).keyword("include"), _function);
        Procedures.Procedure1 _function_1 = it -> it.setNewLines(1, 1, 2);
        doc.append(this.textRegionExtensions.regionFor((EObject)m).feature((EStructuralFeature)VodslPackage.Literals.INCLUDE_DECLARATION__IMPORT_URI), _function_1);
    }

    protected void _format(PackageDeclaration p, @Extension IFormattableDocument doc) {
        Procedures.Procedure1 _function = it -> {
            it.setNewLines(2, 2, 4);
            it.highPriority();
        };
        doc.prepend((EObject)p, _function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        Procedures.Procedure1 _function_2 = it -> it.newLine();
        Procedures.Procedure1 _function_3 = it -> it.newLine();
        Procedures.Procedure1 _function_4 = it -> {
            it.indent();
            it.indent();
        };
        doc.interior(doc.prepend(doc.append(this.textRegionExtensions.regionFor((EObject)p).keyword("{"), _function_1), _function_2), doc.prepend(this.textRegionExtensions.regionFor((EObject)p).keyword("}"), _function_3), _function_4);
        EList<ReferableElement> _elements = p.getElements();
        for (ReferableElement element : _elements) {
            this.format(element, doc);
            Procedures.Procedure1 _function_5 = it -> {
                it.setNewLines(1, 1, 2);
                it.lowPriority();
            };
            doc.prepend((EObject)element, _function_5);
        }
    }

    protected void _format(DataType p, @Extension IFormattableDocument doc) {
        Procedures.Procedure1 _function = it -> it.newLine();
        Procedures.Procedure1 _function_1 = it -> {
            it.setNewLines(0);
            it.oneSpace();
        };
        Procedures.Procedure1 _function_2 = it -> it.newLine();
        Procedures.Procedure1 _function_3 = it -> it.indent();
        doc.interior(doc.prepend(doc.append(this.textRegionExtensions.regionFor((EObject)p).keyword("{"), _function), _function_1), doc.prepend(this.textRegionExtensions.regionFor((EObject)p).keyword("}"), _function_2), _function_3);
        EList<Role> _content = p.getContent();
        for (Role e : _content) {
            this.format(e, doc);
            Procedures.Procedure1 _function_4 = it -> {
                it.setNewLines(1, 1, 2);
                it.lowPriority();
            };
            doc.prepend((EObject)e, _function_4);
        }
    }

    public void format(Object p, IFormattableDocument doc) {
        if (p instanceof DataType) {
            this._format((DataType)p, doc);
            return;
        }
        if (p instanceof XtextResource) {
            this._format((XtextResource)p, doc);
            return;
        }
        if (p instanceof PackageDeclaration) {
            this._format((PackageDeclaration)p, doc);
            return;
        }
        if (p instanceof IncludeDeclaration) {
            this._format((IncludeDeclaration)p, doc);
            return;
        }
        if (p instanceof ModelDeclaration) {
            this._format((ModelDeclaration)p, doc);
            return;
        }
        if (p instanceof VoDataModel) {
            this._format((VoDataModel)p, doc);
            return;
        }
        if (p instanceof EObject) {
            this._format((EObject)p, doc);
            return;
        }
        if (p == null) {
            this._format(null, doc);
            return;
        }
        if (p != null) {
            this._format(p, doc);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(p, doc).toString());
    }
}

