/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.vodsl.generator;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import net.ivoa.vodsl.vodsl.Attribute;
import net.ivoa.vodsl.vodsl.Composition;
import net.ivoa.vodsl.vodsl.Constraint;
import net.ivoa.vodsl.vodsl.ConstraintLanguage;
import net.ivoa.vodsl.vodsl.DataType;
import net.ivoa.vodsl.vodsl.DefinitionType;
import net.ivoa.vodsl.vodsl.EnumLiteral;
import net.ivoa.vodsl.vodsl.Enumeration;
import net.ivoa.vodsl.vodsl.IncludeDeclaration;
import net.ivoa.vodsl.vodsl.ModelDeclaration;
import net.ivoa.vodsl.vodsl.Multiplicity;
import net.ivoa.vodsl.vodsl.MultiplicityBound;
import net.ivoa.vodsl.vodsl.NaturalKey;
import net.ivoa.vodsl.vodsl.ObjectType;
import net.ivoa.vodsl.vodsl.PackageDeclaration;
import net.ivoa.vodsl.vodsl.PrimitiveType;
import net.ivoa.vodsl.vodsl.ReferableElement;
import net.ivoa.vodsl.vodsl.Reference;
import net.ivoa.vodsl.vodsl.Role;
import net.ivoa.vodsl.vodsl.SemanticConcept;
import net.ivoa.vodsl.vodsl.SubSet;
import net.ivoa.vodsl.vodsl.VoDataModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class VodslGenerator
extends AbstractGenerator {
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    private IQualifiedNameConverter converter;
    @Inject
    private ImportUriResolver uriResolver;
    private static final TimeZone tz = TimeZone.getTimeZone("UTC");
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private Date modDate;

    public VodslGenerator() {
        df.setTimeZone(tz);
    }

    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        Date _date;
        VoDataModel vodecl = (VoDataModel)IteratorExtensions.head((Iterator)Iterators.filter((Iterator)resource.getAllContents(), VoDataModel.class));
        vodecl.getModel();
        String filenameOnly = resource.getURI().lastSegment();
        long _timeStamp = resource.getTimeStamp();
        this.modDate = _date = new Date(_timeStamp);
        String _substring = filenameOnly.substring(0, filenameOnly.lastIndexOf("."));
        String filename = String.valueOf(_substring) + ".vo-dml.xml";
        fsa.generateFile(filename, this.vodml(vodecl));
    }

    public CharSequence vodml(VoDataModel e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<vo-dml:model xmlns:vo-dml=\"http://www.ivoa.net/xml/VODML/v1\" ");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("xsi:schemaLocation=\"http://www.ivoa.net/xml/VODML/v1 https://www.ivoa.net/xml/VODML/vo-dml-v1.xsd\" ");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("vodmlVersion=\"1.1\">\t<!-- file generated from VODSL - needs validatation against v1.1 of schema  --> ");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("<name>");
        String _name = e.getModel().getName();
        _builder.append(_name, "      ");
        _builder.append("</name>");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("<description>");
        String _description = e.getModel().getDescription();
        _builder.append(_description, "      ");
        _builder.append("</description> ");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("<uri/>");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("<title>");
        String _titular = e.getModel().getTitular();
        _builder.append(_titular, "      ");
        _builder.append("</title>");
        _builder.newLineIfNotEmpty();
        EList<String> _authors = e.getModel().getAuthors();
        for (String a : _authors) {
            _builder.append("      ");
            _builder.append("<author>");
            _builder.append(a, "      ");
            _builder.append("</author>");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("      ");
        _builder.append("<version>");
        String _version = e.getModel().getVersion();
        _builder.append(_version, "      ");
        _builder.append("</version>");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("<lastModified>");
        String _format = df.format(this.modDate);
        _builder.append(_format, "      ");
        _builder.append("</lastModified>");
        _builder.newLineIfNotEmpty();
        EList<IncludeDeclaration> _includes = e.getIncludes();
        for (IncludeDeclaration f : _includes) {
            _builder.append("      ");
            String _vodml = this.vodml(f);
            _builder.append(_vodml, "      ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("      ");
        CharSequence _vodml_1 = this.vodml((List<ReferableElement>)e.getElements());
        _builder.append((Object)_vodml_1, "      ");
        _builder.newLineIfNotEmpty();
        _builder.append("</vo-dml:model>");
        _builder.newLine();
        return _builder;
    }

    public String vodml(IncludeDeclaration e) {
        boolean _equals;
        Resource resource = EcoreUtil2.getResource((Resource)e.eResource(), (String)this.uriResolver.resolve((EObject)e));
        VoDataModel vodecl = (VoDataModel)IteratorExtensions.head((Iterator)Iterators.filter((Iterator)resource.getAllContents(), VoDataModel.class));
        ModelDeclaration modelDecl = vodecl.getModel();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<import>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("<name>");
        String _name = modelDecl.getName();
        _builder.append(_name, "  ");
        _builder.append("</name>");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("<version>");
        String _version = modelDecl.getVersion();
        _builder.append(_version, "  ");
        _builder.append("</version>");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("<url>");
        String _importURI = e.getImportURI();
        int _xifexpression = 0;
        int _lastIndexOf = e.getImportURI().lastIndexOf("/");
        boolean bl = _equals = _lastIndexOf == -1;
        if (_equals) {
            _xifexpression = 0;
        } else {
            int _lastIndexOf_1 = e.getImportURI().lastIndexOf("/");
            _xifexpression = _lastIndexOf_1 + 1;
        }
        String _substring = _importURI.substring(_xifexpression, e.getImportURI().lastIndexOf("."));
        String _plus = String.valueOf(_substring) + ".vo-dml.xml";
        _builder.append(_plus, "  ");
        _builder.append("</url>");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("<documentationURL>not known</documentationURL>");
        _builder.newLine();
        _builder.append("</import>");
        _builder.newLine();
        return _builder.toString();
    }

    public CharSequence vodml(ReferableElement e) {
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (e instanceof PackageDeclaration) {
            _matched = true;
            _switchResult = this.vodml((PackageDeclaration)e);
        }
        if (!_matched && e instanceof ObjectType) {
            _matched = true;
            _switchResult = this.vodml((ObjectType)e);
        }
        if (!_matched && e instanceof Enumeration) {
            _matched = true;
            _switchResult = this.vodml((Enumeration)e);
        }
        if (!_matched && e instanceof DataType) {
            _matched = true;
            _switchResult = this.vodml((DataType)e);
        }
        if (!_matched && e instanceof PrimitiveType) {
            _matched = true;
            _switchResult = this.vodml((PrimitiveType)e);
        }
        if (!_matched && e instanceof Attribute) {
            _matched = true;
            _switchResult = this.vodml((Attribute)e);
        }
        if (!_matched) {
            Class<?> _class = e.getClass();
            _switchResult = "unknown type " + _class;
        }
        return _switchResult;
    }

    public CharSequence vodml(Role e) {
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (e instanceof Composition) {
            _matched = true;
            _switchResult = this.vodml((Composition)e);
        }
        if (!_matched && e instanceof Reference) {
            _matched = true;
            _switchResult = this.vodml((Reference)e);
        }
        if (!_matched && e instanceof Attribute) {
            _matched = true;
            _switchResult = this.vodml((Attribute)e);
        }
        if (!_matched) {
            Class<?> _class = e.getClass();
            _switchResult = "unknown type " + _class;
        }
        return _switchResult;
    }

    public CharSequence preamble(ReferableElement e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<vodml-id>");
        QualifiedName _skipFirst = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)e).skipFirst(1);
        _builder.append((Object)_skipFirst);
        _builder.append("</vodml-id>");
        _builder.newLineIfNotEmpty();
        _builder.append("<name>");
        String _name = e.getName();
        _builder.append(_name);
        _builder.append("</name>");
        _builder.newLineIfNotEmpty();
        _builder.append("<description>");
        String _description = e.getDescription();
        _builder.append(_description);
        _builder.append("</description>\t    ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence vodml(List<ReferableElement> e) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _filter = Iterables.filter(e, PrimitiveType.class);
        for (PrimitiveType f : _filter) {
            CharSequence _vodml = this.vodml(f);
            _builder.append((Object)_vodml);
            _builder.newLineIfNotEmpty();
        }
        Iterable _filter_1 = Iterables.filter(e, Enumeration.class);
        for (Enumeration f_1 : _filter_1) {
            _builder.append("      ");
            CharSequence _vodml_1 = this.vodml(f_1);
            _builder.append((Object)_vodml_1, "      ");
            _builder.newLineIfNotEmpty();
        }
        Iterable _filter_2 = Iterables.filter(e, DataType.class);
        for (DataType f_2 : _filter_2) {
            _builder.append("      ");
            CharSequence _vodml_2 = this.vodml(f_2);
            _builder.append((Object)_vodml_2, "      ");
            _builder.newLineIfNotEmpty();
        }
        Iterable _filter_3 = Iterables.filter(e, ObjectType.class);
        for (ObjectType f_3 : _filter_3) {
            _builder.append("      ");
            CharSequence _vodml_3 = this.vodml(f_3);
            _builder.append((Object)_vodml_3, "      ");
            _builder.newLineIfNotEmpty();
        }
        Iterable _filter_4 = Iterables.filter(e, PackageDeclaration.class);
        for (PackageDeclaration f_4 : _filter_4) {
            _builder.append("      ");
            CharSequence _vodml_4 = this.vodml(f_4);
            _builder.append((Object)_vodml_4, "      ");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence vodml(PackageDeclaration e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<package>");
        _builder.newLine();
        _builder.append("   ");
        CharSequence _preamble = this.preamble(e);
        _builder.append((Object)_preamble, "   ");
        _builder.newLineIfNotEmpty();
        _builder.append("       ");
        CharSequence _vodml = this.vodml((List<ReferableElement>)e.getElements());
        _builder.append((Object)_vodml, "       ");
        _builder.newLineIfNotEmpty();
        _builder.append("</package>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence vodml(ObjectType e) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<objectType");
        boolean _isAbstract = e.isAbstract();
        if (_isAbstract) {
            _builder.append(" abstract=\"true\"");
        }
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        _builder.append("   ");
        CharSequence _preamble = this.preamble(e);
        _builder.append((Object)_preamble, "   ");
        _builder.newLineIfNotEmpty();
        ObjectType _superType = e.getSuperType();
        boolean bl = _tripleNotEquals = _superType != null;
        if (_tripleNotEquals) {
            _builder.append("   ");
            _builder.append("<extends>");
            _builder.newLine();
            _builder.append("   ");
            _builder.append("   ");
            ObjectType _superType_1 = e.getSuperType();
            CharSequence _ref = this.ref(_superType_1);
            _builder.append((Object)_ref, "      ");
            _builder.newLineIfNotEmpty();
            _builder.append("   ");
            _builder.append("</extends>");
            _builder.newLine();
        }
        EList<Constraint> _constraints = e.getConstraints();
        for (Constraint f : _constraints) {
            _builder.append("   ");
            CharSequence _vodml = this.vodml(f);
            _builder.append((Object)_vodml, "   ");
            _builder.newLineIfNotEmpty();
        }
        EList<SubSet> _subsets = e.getSubsets();
        for (SubSet f_1 : _subsets) {
            _builder.append("   ");
            CharSequence _vodml_1 = this.vodml(f_1);
            _builder.append((Object)_vodml_1, "   ");
            _builder.newLineIfNotEmpty();
        }
        EList<Role> _content = e.getContent();
        for (Role f_2 : _content) {
            _builder.append("   ");
            CharSequence _vodml_2 = this.vodml(f_2);
            _builder.append((Object)_vodml_2, "   ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</objectType>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence vodml(Attribute e) {
        NaturalKey _key;
        boolean _tripleNotEquals_2;
        String _ucd;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<attribute>");
        _builder.newLine();
        _builder.append("  ");
        CharSequence _preamble = this.preamble(e);
        _builder.append((Object)_preamble, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("<datatype>");
        _builder.newLine();
        _builder.append("     ");
        DefinitionType _type = e.getType();
        CharSequence _ref = this.ref(_type);
        _builder.append((Object)_ref, "     ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("</datatype>");
        _builder.newLine();
        _builder.append("  ");
        CharSequence _vodml = this.vodml(e.getMultiplicity());
        _builder.append((Object)_vodml, "  ");
        _builder.newLineIfNotEmpty();
        SemanticConcept _semanticConcept = e.getSemanticConcept();
        boolean bl = _tripleNotEquals = _semanticConcept != null;
        if (_tripleNotEquals) {
            CharSequence _vodml_1 = this.vodml(e.getSemanticConcept());
            _builder.append((Object)_vodml_1);
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _tripleNotEquals_1 = (_ucd = e.getUcd()) != null;
        if (_tripleNotEquals_1) {
            _builder.append("    ");
            _builder.append("<UCD>");
            String _ucd_1 = e.getUcd();
            _builder.append(_ucd_1, "    ");
            _builder.append("</UCD>");
            _builder.newLineIfNotEmpty();
        }
        boolean bl3 = _tripleNotEquals_2 = (_key = e.getKey()) != null;
        if (_tripleNotEquals_2) {
            CharSequence _vodml_2 = this.vodml(e.getKey());
            _builder.append((Object)_vodml_2);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</attribute>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence vodml(Composition e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<composition>");
        _builder.newLine();
        _builder.append("  ");
        CharSequence _preamble = this.preamble(e);
        _builder.append((Object)_preamble, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("<datatype>");
        _builder.newLine();
        _builder.append("     ");
        ObjectType _type = e.getType();
        CharSequence _ref = this.ref(_type);
        _builder.append((Object)_ref, "     ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("</datatype>");
        _builder.newLine();
        _builder.append("  ");
        CharSequence _vodml = this.vodml(e.getMultiplicity());
        _builder.append((Object)_vodml, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        boolean _isOrdered = e.isOrdered();
        if (_isOrdered) {
            _builder.append("<isOrdered>true</isOrdered>");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("</composition>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence ref(ReferableElement e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<vodml-ref>");
        String _string = this.converter.toString(this._iQualifiedNameProvider.getFullyQualifiedName((EObject)e));
        _builder.append(_string);
        _builder.append("</vodml-ref>");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence vodml(Reference e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<reference>");
        _builder.newLine();
        _builder.append("  ");
        CharSequence _preamble = this.preamble(e);
        _builder.append((Object)_preamble, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("<datatype>");
        _builder.newLine();
        _builder.append("    ");
        ObjectType _type = e.getType();
        CharSequence _ref = this.ref(_type);
        _builder.append((Object)_ref, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("</datatype>");
        _builder.newLine();
        _builder.append("  ");
        CharSequence _vodml = this.vodml(e.getMultiplicity());
        _builder.append((Object)_vodml, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("</reference>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence vodml(Constraint e) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<constraint>");
        _builder.newLine();
        String _expr = e.getExpr();
        boolean bl = _tripleNotEquals = _expr != null;
        if (_tripleNotEquals) {
            _builder.append("   ");
            _builder.append("<description><![CDATA[");
            String _expr_1 = e.getExpr();
            _builder.append(_expr_1, "   ");
            _builder.append("]]></description>");
            _builder.newLineIfNotEmpty();
            _builder.append("   ");
            _builder.append("<!-- <language>");
            ConstraintLanguage _language = e.getLanguage();
            _builder.append((Object)_language, "   ");
            _builder.append("</language> -->");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</constraint>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence vodml(Enumeration e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<enumeration>");
        _builder.newLine();
        _builder.append("   ");
        CharSequence _preamble = this.preamble(e);
        _builder.append((Object)_preamble, "   ");
        _builder.newLineIfNotEmpty();
        EList<EnumLiteral> _literals = e.getLiterals();
        for (EnumLiteral f : _literals) {
            _builder.append("      ");
            CharSequence _vodml = this.vodml(f);
            _builder.append((Object)_vodml, "      ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</enumeration>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence vodml(DataType e) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<dataType");
        boolean _isAbstract = e.isAbstract();
        if (_isAbstract) {
            _builder.append(" abstract=\"true\"");
        }
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _preamble = this.preamble(e);
        _builder.append((Object)_preamble, "  ");
        _builder.newLineIfNotEmpty();
        DataType _superType = e.getSuperType();
        boolean bl = _tripleNotEquals = _superType != null;
        if (_tripleNotEquals) {
            _builder.append("   ");
            _builder.append("<extends>");
            _builder.newLine();
            _builder.append("   ");
            _builder.append("   ");
            DataType _superType_1 = e.getSuperType();
            CharSequence _ref = this.ref(_superType_1);
            _builder.append((Object)_ref, "      ");
            _builder.newLineIfNotEmpty();
            _builder.append("   ");
            _builder.append("</extends>");
            _builder.newLine();
        }
        EList<Constraint> _constraints = e.getConstraints();
        for (Constraint f : _constraints) {
            _builder.append("   ");
            CharSequence _vodml = this.vodml(f);
            _builder.append((Object)_vodml, "   ");
            _builder.newLineIfNotEmpty();
        }
        EList<SubSet> _subsets = e.getSubsets();
        for (SubSet f_1 : _subsets) {
            _builder.append("       ");
            CharSequence _vodml_1 = this.vodml(f_1);
            _builder.append((Object)_vodml_1, "       ");
            _builder.newLineIfNotEmpty();
        }
        EList<Role> _content = e.getContent();
        for (Role f_2 : _content) {
            CharSequence _vodml_2 = this.vodml(f_2);
            _builder.append((Object)_vodml_2);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</dataType>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence vodml(Multiplicity e) {
        CharSequence _xifexpression = null;
        if (e != null) {
            boolean _tripleNotEquals;
            CharSequence _xifexpression_1 = null;
            MultiplicityBound _multiplicitySpec = e.getMultiplicitySpec();
            boolean bl = _tripleNotEquals = _multiplicitySpec != null;
            if (_tripleNotEquals) {
                CharSequence _switchResult = null;
                MultiplicityBound _multiplicitySpec_1 = e.getMultiplicitySpec();
                if (_multiplicitySpec_1 != null) {
                    switch (_multiplicitySpec_1) {
                        case ATLEASTONE: {
                            _switchResult = this.vodml(1, -1);
                            break;
                        }
                        case MANY: {
                            _switchResult = this.vodml(0, -1);
                            break;
                        }
                        case OPTIONAL: {
                            _switchResult = this.vodml(0, 1);
                            break;
                        }
                        case ONE: {
                            CharSequence _xifexpression_2 = null;
                            int _minOccurs = e.getMinOccurs();
                            boolean _notEquals = _minOccurs != 0;
                            _xifexpression_2 = _notEquals ? this.vodml(e.getMinOccurs(), e.getMinOccurs()) : this.vodml(1, 1);
                            _switchResult = _xifexpression_2;
                            break;
                        }
                        default: {
                            _switchResult = this.vodml(1, 1);
                            break;
                        }
                    }
                } else {
                    _switchResult = this.vodml(1, 1);
                }
                _xifexpression_1 = _switchResult;
            } else {
                _xifexpression_1 = this.vodml(e.getMinOccurs(), e.getMaxOccurs());
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = this.vodml(1, 1);
        }
        return _xifexpression;
    }

    public CharSequence vodml(int minOccurs, int maxOccurs) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<multiplicity>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("<minOccurs>");
        _builder.append((Object)minOccurs, "  ");
        _builder.append("</minOccurs>");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("<maxOccurs>");
        _builder.append((Object)maxOccurs, "  ");
        _builder.append("</maxOccurs>");
        _builder.newLineIfNotEmpty();
        _builder.append("</multiplicity>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence vodml(PrimitiveType e) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<primitiveType ");
        boolean _isAbstract = e.isAbstract();
        if (_isAbstract) {
            _builder.append(" abstract=\"true\"");
        }
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        CharSequence _preamble = this.preamble(e);
        _builder.append((Object)_preamble);
        _builder.newLineIfNotEmpty();
        PrimitiveType _superType = e.getSuperType();
        boolean bl = _tripleNotEquals = _superType != null;
        if (_tripleNotEquals) {
            _builder.append("<extends>");
            _builder.newLine();
            _builder.append("   ");
            PrimitiveType _superType_1 = e.getSuperType();
            CharSequence _ref = this.ref(_superType_1);
            _builder.append((Object)_ref, "   ");
            _builder.newLineIfNotEmpty();
            _builder.append("</extends>");
            _builder.newLine();
        }
        _builder.append("</primitiveType>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence vodml(EnumLiteral e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<literal>");
        _builder.newLine();
        _builder.append("  ");
        CharSequence _preamble = this.preamble(e);
        _builder.append((Object)_preamble, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("</literal>\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence vodml(SubSet e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<constraint xsi:type=\"vo-dml:SubsettedRole\">");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("<role>");
        _builder.newLine();
        _builder.append("      ");
        Role _ref = e.getRef();
        CharSequence _ref_1 = this.ref(_ref);
        _builder.append((Object)_ref_1, "      ");
        _builder.newLineIfNotEmpty();
        _builder.append("   ");
        _builder.append("</role>");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("<datatype>");
        _builder.newLine();
        _builder.append("      ");
        DefinitionType _type = e.getType();
        CharSequence _ref_2 = this.ref(_type);
        _builder.append((Object)_ref_2, "      ");
        _builder.newLineIfNotEmpty();
        _builder.append("   ");
        _builder.append("</datatype>");
        _builder.newLine();
        _builder.append("</constraint>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence vodml(NaturalKey e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<constraint xsi:type=\"vo-dml:NaturalKey\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<position>");
        int _xifexpression = 0;
        int _position = e.getPosition();
        boolean _lessThan = _position < 1;
        _xifexpression = _lessThan ? 1 : e.getPosition();
        _builder.append((Object)_xifexpression, "\t");
        _builder.append("</position>");
        _builder.newLineIfNotEmpty();
        _builder.append("</constraint>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence vodml(SemanticConcept e) {
        String _vocabularyURI;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<semanticconcept>");
        _builder.newLine();
        String _broadestConcept = e.getBroadestConcept();
        boolean bl = _tripleNotEquals = _broadestConcept != null;
        if (_tripleNotEquals) {
            _builder.append("  ");
            _builder.append("<topConcept>");
            String _broadestConcept_1 = e.getBroadestConcept();
            _builder.append(_broadestConcept_1, "  ");
            _builder.append("</topConcept>");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _tripleNotEquals_1 = (_vocabularyURI = e.getVocabularyURI()) != null;
        if (_tripleNotEquals_1) {
            _builder.append("  ");
            _builder.append("<vocabularyURI>");
            String _vocabularyURI_1 = e.getVocabularyURI();
            _builder.append(_vocabularyURI_1, "  ");
            _builder.append("</vocabularyURI>");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</semanticconcept>");
        _builder.newLine();
        return _builder;
    }
}

