/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.vodsl.scoping;

import com.google.inject.Singleton;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;

@Singleton
public class VodslQualifiedNameConverter
implements IQualifiedNameConverter {
    public String toString(QualifiedName qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Qualified name cannot be null");
        }
        int delimiter = 58;
        int segmentCount = qualifiedName.getSegmentCount();
        switch (segmentCount) {
            case 0: {
                return "";
            }
            case 1: {
                return qualifiedName.getFirstSegment();
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append(qualifiedName.getFirstSegment());
        int i = 1;
        while (i < segmentCount) {
            builder.append((char)delimiter);
            builder.append(qualifiedName.getSegment(i));
            delimiter = 46;
            ++i;
        }
        return builder.toString();
    }

    public QualifiedName toQualifiedName(String qualifiedNameAsString) {
        if (qualifiedNameAsString == null) {
            throw new IllegalArgumentException("Qualified name cannot be null");
        }
        if (qualifiedNameAsString.equals("")) {
            throw new IllegalArgumentException("Qualified name cannot be empty");
        }
        String[] segs = qualifiedNameAsString.split(":|\\.");
        return QualifiedName.create((String[])segs);
    }
}

