/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.vodsl.validation;

import com.google.common.base.Objects;
import net.ivoa.vodsl.validation.AbstractVodslValidator;
import net.ivoa.vodsl.vodsl.Attribute;
import net.ivoa.vodsl.vodsl.Composition;
import net.ivoa.vodsl.vodsl.DataType;
import net.ivoa.vodsl.vodsl.DefinitionType;
import net.ivoa.vodsl.vodsl.Multiplicity;
import net.ivoa.vodsl.vodsl.MultiplicityBound;
import net.ivoa.vodsl.vodsl.Reference;
import net.ivoa.vodsl.vodsl.ValueType;
import net.ivoa.vodsl.vodsl.VodslPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class VodslValidator
extends AbstractVodslValidator {
    @Check
    public void checkAttributeType(Attribute attr) {
        boolean _not;
        DefinitionType _type = attr.getType();
        boolean bl = _not = !(_type instanceof ValueType);
        if (_not) {
            String _name = attr.getName();
            String _plus = "Attribute '" + _name;
            String _plus_1 = String.valueOf(_plus) + "' should be a value type";
            this.error(_plus_1, (EStructuralFeature)VodslPackage.Literals.ATTRIBUTE__TYPE);
        }
    }

    public void checkAbstract(DataType t) {
        boolean _isEmpty;
        boolean _isAbstract = t.isAbstract();
        if (_isAbstract && (_isEmpty = t.getContent().isEmpty())) {
            this.warning("abstract datatype with no members ", (EStructuralFeature)VodslPackage.Literals.DEFINITION_TYPE__ABSTRACT);
        }
    }

    @Check
    public Object checkMultiplicity(Multiplicity mul) {
        Object _xblockexpression = null;
        EObject typ = mul.eContainer();
        Object _switchResult = null;
        boolean _matched = false;
        if (typ instanceof Attribute) {
            _matched = true;
            _switchResult = this.checkMultiplicity((Attribute)typ);
        }
        if (!_matched && typ instanceof Reference) {
            _matched = true;
            _switchResult = this.checkMultiplicity((Reference)typ);
        }
        if (!_matched && typ instanceof Composition) {
            _matched = true;
            this.checkMultiplicity((Composition)typ);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public Object checkMultiplicity(Reference typ) {
        boolean _notEquals;
        Object _xblockexpression = null;
        Multiplicity mul = typ.getMultiplicity();
        Object _xifexpression = null;
        MultiplicityBound _multiplicitySpec = mul.getMultiplicitySpec();
        boolean bl = _notEquals = !Objects.equal((Object)((Object)_multiplicitySpec), null);
        if (_notEquals) {
            Object _switchResult = null;
            MultiplicityBound _multiplicitySpec_1 = mul.getMultiplicitySpec();
            if (_multiplicitySpec_1 != null) {
                switch (_multiplicitySpec_1) {
                    case ATLEASTONE: {
                        String _name = typ.getName();
                        String _plus = "multiplicity '+' not advised for reference " + _name;
                        String _plus_1 = String.valueOf(_plus) + "\n unless pure aggregation\n see VO-DML spec 4.19 ";
                        this.warning(_plus_1, (EStructuralFeature)VodslPackage.Literals.MULTIPLICITY__MULTIPLICITY_SPEC);
                        break;
                    }
                    case MANY: {
                        String _name_1 = typ.getName();
                        String _plus_2 = "multiplicity '*' not advised for reference" + _name_1;
                        String _plus_3 = String.valueOf(_plus_2) + "\n see VO-DML spec 4.19";
                        this.error(_plus_3, (EStructuralFeature)VodslPackage.Literals.MULTIPLICITY__MULTIPLICITY_SPEC);
                        break;
                    }
                    case OPTIONAL: {
                        _switchResult = null;
                        break;
                    }
                    case ONE: {
                        if (mul.getMaxOccurs() == 1 && mul.getMinOccurs() == 1) break;
                        String _name_2 = typ.getName();
                        String _plus_4 = "max occurs > 1 not advised for reference" + _name_2;
                        String _plus_5 = String.valueOf(_plus_4) + "\n see VO-DML spec 4.19 ";
                        this.warning(_plus_5, (EStructuralFeature)VodslPackage.Literals.MULTIPLICITY__MAX_OCCURS);
                        break;
                    }
                }
            }
            _xifexpression = _switchResult;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void checkMultiplicity(Composition typ) {
        Multiplicity mul = typ.getMultiplicity();
        if (Objects.equal((Object)((Object)mul.getMultiplicitySpec()), null) || Objects.equal((Object)((Object)mul.getMultiplicitySpec()), (Object)((Object)MultiplicityBound.ONE))) {
            int _minOccurs;
            boolean _lessThan;
            int _maxOccurs = mul.getMaxOccurs();
            boolean bl = _lessThan = _maxOccurs < (_minOccurs = mul.getMinOccurs());
            if (_lessThan) {
                String _name = typ.getName();
                String _plus = "maximum multiplicity less than minimum - " + _name;
                this.error(_plus, (EStructuralFeature)VodslPackage.Literals.MULTIPLICITY__MAX_OCCURS);
            }
        }
    }

    public Object checkMultiplicity(Attribute typ) {
        boolean _notEquals;
        Object _xblockexpression = null;
        Multiplicity mul = typ.getMultiplicity();
        Object _xifexpression = null;
        MultiplicityBound _multiplicitySpec = mul.getMultiplicitySpec();
        boolean bl = _notEquals = !Objects.equal((Object)((Object)_multiplicitySpec), null);
        if (_notEquals) {
            Object _switchResult = null;
            MultiplicityBound _multiplicitySpec_1 = mul.getMultiplicitySpec();
            if (_multiplicitySpec_1 != null) {
                switch (_multiplicitySpec_1) {
                    case ATLEASTONE: {
                        String _name = typ.getName();
                        String _plus = "multiplicity '+' strongly discouraged for attribute " + _name;
                        this.error(_plus, (EStructuralFeature)VodslPackage.Literals.MULTIPLICITY__MULTIPLICITY_SPEC);
                        break;
                    }
                    case MANY: {
                        String _name_1 = typ.getName();
                        String _plus_1 = "multiplicity '*' strongly discouraged for attribute " + _name_1;
                        this.error(_plus_1, (EStructuralFeature)VodslPackage.Literals.MULTIPLICITY__MULTIPLICITY_SPEC);
                        break;
                    }
                    case OPTIONAL: {
                        _switchResult = null;
                        break;
                    }
                    case ONE: {
                        if (mul.getMaxOccurs() == 0 || mul.getMinOccurs() == mul.getMaxOccurs()) break;
                        String _name_2 = typ.getName();
                        String _plus_2 = "multiplicity for attribute should specify array size so that min=max for " + _name_2;
                        this.error(_plus_2, (EStructuralFeature)VodslPackage.Literals.MULTIPLICITY__MAX_OCCURS);
                        break;
                    }
                }
            }
            _xifexpression = _switchResult;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

