/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.vodsl.standalone;

import com.google.inject.Injector;
import java.util.List;
import net.ivoa.vodsl.VodslStandaloneSetup;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class ParserRunner {
    private final Injector injector = new VodslStandaloneSetup().createInjectorAndDoEMFRegistration();
    private XtextResourceSet resourceSet = (XtextResourceSet)this.injector.getInstance(XtextResourceSet.class);

    public void parse(String[] files, String outputPath) {
        Resource resource = this.resourceSet.getResource(URI.createFileURI((String)files[0]), true);
        for (int i = 1; i < files.length; ++i) {
            this.resourceSet.getResource(URI.createFileURI((String)files[i]), true);
        }
        IResourceValidator validator = ((XtextResource)resource).getResourceServiceProvider().getResourceValidator();
        List issues = validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
        for (Issue issue : issues) {
            System.err.println(issue.getMessage());
        }
        GeneratorDelegate generator = (GeneratorDelegate)this.injector.getInstance(GeneratorDelegate.class);
        JavaIoFileSystemAccess fsa = (JavaIoFileSystemAccess)this.injector.getInstance(JavaIoFileSystemAccess.class);
        fsa.setOutputPath(outputPath);
        generator.doGenerate(resource, (IFileSystemAccess)fsa);
    }

    public static void main(String[] args) {
        ParserRunner pr = new ParserRunner();
        if (args.length > 0) {
            pr.parse(args, ".");
        } else {
            System.err.println("you must supply at least one file to parse.");
        }
    }
}

