/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.command.impl.account;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.javaswift.joss.command.impl.account.AbstractAccountCommand;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusChecker;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusMatch;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusSuccessCondition;
import org.javaswift.joss.command.shared.account.ContainerListElement;
import org.javaswift.joss.command.shared.account.ListContainersCommand;
import org.javaswift.joss.instructions.ListInstructions;
import org.javaswift.joss.model.Access;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.Container;

public class ListContainersCommandImpl
extends AbstractAccountCommand<HttpGet, Collection<Container>>
implements ListContainersCommand {
    protected Account account;

    public ListContainersCommandImpl(Account account, HttpClient httpClient, Access access, ListInstructions listInstructions) {
        super(account, httpClient, access);
        this.account = account;
        this.modifyURI(listInstructions.getQueryParameters());
    }

    @Override
    protected Collection<Container> getReturnObject(HttpResponse response) throws IOException {
        ContainerListElement[] list = (ContainerListElement[])this.createObjectMapper(false).readValue(response.getEntity().getContent(), ContainerListElement[].class);
        ArrayList<Container> containers = new ArrayList<Container>();
        for (ContainerListElement containerHeader : list) {
            Container container = this.account.getContainer(containerHeader.name);
            container.setCount(containerHeader.count);
            container.setBytesUsed(containerHeader.bytes);
            container.metadataSetFromHeaders();
            containers.add(container);
        }
        return containers;
    }

    @Override
    protected HttpGet createRequest(String url) {
        return new HttpGet(url);
    }

    @Override
    public HttpStatusChecker[] getStatusCheckers() {
        return new HttpStatusChecker[]{new HttpStatusSuccessCondition(new HttpStatusMatch(200)), new HttpStatusSuccessCondition(new HttpStatusMatch(204))};
    }
}

