/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.instructions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.HttpEntity;
import org.javaswift.joss.exception.CommandException;
import org.javaswift.joss.headers.Header;
import org.javaswift.joss.headers.object.DeleteAfter;
import org.javaswift.joss.headers.object.DeleteAt;
import org.javaswift.joss.headers.object.Etag;
import org.javaswift.joss.headers.object.ObjectContentType;
import org.javaswift.joss.headers.object.ObjectManifest;
import org.javaswift.joss.instructions.SegmentationPlan;
import org.javaswift.joss.instructions.UploadPayload;
import org.javaswift.joss.instructions.UploadPayloadByteArray;
import org.javaswift.joss.instructions.UploadPayloadFile;
import org.javaswift.joss.instructions.UploadPayloadInputStream;

public class UploadInstructions {
    private Map<String, Header> headers;
    public static Long MAX_SEGMENTATION_SIZE = 0x140000000L;
    private UploadPayload uploadPayload;
    private String md5;
    private ObjectContentType contentType;
    private DeleteAfter deleteAfter;
    private DeleteAt deleteAt;
    private ObjectManifest objectManifest;
    private Long segmentationSize = MAX_SEGMENTATION_SIZE;

    public UploadInstructions(File fileToUpload) {
        this.uploadPayload = new UploadPayloadFile(fileToUpload);
    }

    public UploadInstructions(InputStream inputStream) {
        this.uploadPayload = new UploadPayloadInputStream(inputStream);
    }

    public UploadInstructions(byte[] fileToUpload) {
        this.uploadPayload = new UploadPayloadByteArray(fileToUpload);
    }

    public boolean requiresSegmentation() {
        return this.uploadPayload.mustBeSegmented(this.segmentationSize);
    }

    public SegmentationPlan getSegmentationPlan() {
        try {
            return this.uploadPayload.getSegmentationPlan(this.segmentationSize);
        }
        catch (IOException err) {
            throw new CommandException("Unable to set up segmentation plan", err);
        }
    }

    public UploadInstructions setObjectManifest(ObjectManifest objectManifest) {
        this.objectManifest = objectManifest;
        return this;
    }

    public UploadInstructions setMd5(String md5) {
        this.md5 = md5;
        return this;
    }

    public UploadInstructions setContentType(String contentType) {
        return this.setContentType(new ObjectContentType(contentType));
    }

    public UploadInstructions setContentType(ObjectContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public UploadInstructions setDeleteAfter(DeleteAfter deleteAfter) {
        this.deleteAfter = deleteAfter;
        return this;
    }

    public UploadInstructions setDeleteAt(DeleteAt deleteAt) {
        this.deleteAt = deleteAt;
        return this;
    }

    public UploadInstructions setSegmentationSize(Long segmentationSize) {
        this.segmentationSize = segmentationSize;
        return this;
    }

    public HttpEntity getEntity() {
        return this.uploadPayload.getEntity();
    }

    public Long getSegmentationSize() {
        return this.segmentationSize;
    }

    public String getMd5() {
        return this.md5;
    }

    public Etag getEtag() throws IOException {
        return this.getMd5() == null ? this.uploadPayload.getEtag() : new Etag(this.getMd5());
    }

    public ObjectManifest getObjectManifest() {
        return this.objectManifest;
    }

    public ObjectContentType getContentType() {
        return this.contentType;
    }

    public DeleteAt getDeleteAt() {
        return this.deleteAt;
    }

    public DeleteAfter getDeleteAfter() {
        return this.deleteAfter;
    }

    public UploadInstructions addHeader(Header header) {
        if (this.headers == null) {
            this.headers = new TreeMap<String, Header>();
        }
        this.headers.put(header.getHeaderName(), header);
        return this;
    }

    public Map<String, Header> getHeaders() {
        return this.headers;
    }
}

