package org.javaswift.joss.information;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import org.javaswift.joss.headers.Header;
import org.javaswift.joss.headers.object.DeleteAfter;
import org.javaswift.joss.headers.object.DeleteAt;
import org.javaswift.joss.headers.object.Etag;
import org.javaswift.joss.headers.object.ObjectContentLength;
import org.javaswift.joss.headers.object.ObjectContentType;
import org.javaswift.joss.headers.object.ObjectLastModified;
import org.javaswift.joss.headers.object.ObjectManifest;

public class ObjectInformation extends AbstractInformation {

    private ObjectLastModified lastModified;
    private Etag etag;
    private ObjectContentLength contentLength;
    private ObjectContentType contentType;
    private DeleteAfter deleteAfter;
    private DeleteAt deleteAt;
    private ObjectManifest manifest ;

    public Date getLastModifiedAsDate() {
        return lastModified == null ? null : lastModified.getDate();
    }

    public String getLastModified() {
        return lastModified == null ? null : lastModified.getHeaderValue();
    }

    public void setLastModified(ObjectLastModified lastModified) {
        this.lastModified = lastModified;
    }

    public String getEtag() {
        return etag.getHeaderValue();
    }

    public void setEtag(Etag etag) {
        this.etag = etag;
    }

    public long getContentLength() {
        return Long.parseLong(contentLength.getHeaderValue());
    }

    public void setContentLength(ObjectContentLength contentLength) {
        this.contentLength = contentLength;
    }

    public Header getContentTypeHeader() {
        return this.contentType;
    }

    public String getContentType() {
        return contentType.getHeaderValue();
    }

    public void setContentType(ObjectContentType contentType) {
        this.contentType = contentType;
    }

    public void setDeleteAt(DeleteAt deleteAt) {
        this.deleteAt = deleteAt;
    }

    public DeleteAt getDeleteAt() {
        return this.deleteAt;
    }

    public void setDeleteAfter(DeleteAfter deleteAfter) {
        this.deleteAfter = deleteAfter;
    }

    public DeleteAfter getDeleteAfter() {
        return this.deleteAfter;
    }

    public void addHeader(Collection<Header> headers, Header header) {
        if (header == null) {
            return;
        }
        headers.add(header);
    }

    public String getManifest () {
    	return (manifest == null) ? (null) : (manifest.getHeaderValue()) ;
    }

    public void setManifest(ObjectManifest manifest) {
        this.manifest = manifest;
    }

    protected ObjectManifest getObjectManifest() {
    	return this.manifest;
    }

    public Collection<Header> getHeaders() {
        Collection<Header> headers = new ArrayList<Header>();
        addHeader(headers, getDeleteAfter());
        addHeader(headers, getDeleteAt());
        addHeader(headers, getObjectManifest());
        headers.addAll(getMetadata()); // The original metadata must be passed as well, otherwise it's deleted
        return headers;
    }

    public Collection<Header> getHeadersIncludingHeader(Header header) {
        Collection<Header> headers = getHeaders();
        addHeader(headers, header);
        return headers;
    }
}
