/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.command.impl.core;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusChecker;
import org.javaswift.joss.exception.CommandException;
import org.javaswift.joss.instructions.QueryParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommand<M extends HttpRequestBase, N>
implements Callable<N>,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractCommand.class);
    private HttpClient httpClient;
    protected M request;
    protected HttpResponse response;
    private boolean allowErrorLog = true;

    public AbstractCommand(HttpClient httpClient, String url) {
        this.httpClient = httpClient;
        this.request = this.createRequest(url);
    }

    public void setAllowErrorLog(boolean allowErrorLog) {
        this.allowErrorLog = allowErrorLog;
    }

    @Override
    public N call() {
        N n;
        this.logCall(this.request);
        try {
            this.response = this.httpClient.execute(this.request);
            HttpStatusChecker.verifyCode(this.getStatusCheckers(), this.response.getStatusLine().getStatusCode());
            n = this.getReturnObject(this.response);
        }
        catch (CommandException err) {
            this.request.releaseConnection();
            if (this.allowErrorLog) {
                this.logError(this.request, err);
            }
            throw err;
        }
        catch (IOException err) {
            this.request.releaseConnection();
            throw new CommandException("Unable to execute the HTTP call or to convert the HTTP Response", err);
        }
        finally {
            if (this.closeStreamAutomatically()) {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
        }
        return n;
    }

    private void logCall(M request) {
        LOG.debug("JOSS / Sending " + this.getPrintableCall(request));
        for (String printableHeaderLine : this.getPrintableHeaderLines(request)) {
            LOG.debug("* " + printableHeaderLine);
        }
    }

    private void logError(M request, CommandException err) {
        LOG.error("JOSS / " + this.getPrintableCall(request) + (err.getHttpStatusCode() == 0 ? "" : ", HTTP status " + err.getHttpStatusCode()) + (err.getError() == null ? "" : ", Error " + (Object)((Object)err.getError())) + (err.getMessage() == null ? "" : ", Message '" + err.getMessage() + "'") + (err.getCause() == null ? "" : ", Cause " + err.getCause().getClass().getSimpleName()));
        for (String printableHeaderLine : this.getPrintableHeaderLines(request)) {
            LOG.error("* " + printableHeaderLine);
        }
    }

    private String getPrintableCall(M request) {
        return "HTTP " + request.getMethod() + " call " + request.getURI().toString();
    }

    private List<String> getPrintableHeaderLines(M request) {
        ArrayList<String> printableHeaderLines = new ArrayList<String>();
        for (Header header : request.getAllHeaders()) {
            printableHeaderLines.add(header.getName() + "=" + header.getValue());
        }
        return printableHeaderLines;
    }

    protected void setHeader(org.javaswift.joss.headers.Header header) {
        if (header == null) {
            return;
        }
        header.setHeader((HttpRequestBase)this.request);
    }

    @Override
    public void close() throws IOException {
        if (this.response != null) {
            EntityUtils.consume((HttpEntity)this.response.getEntity());
        }
    }

    protected boolean closeStreamAutomatically() {
        return true;
    }

    protected void addHeaders(Collection<? extends org.javaswift.joss.headers.Header> headers) {
        for (org.javaswift.joss.headers.Header header : headers) {
            this.setHeader(header);
        }
    }

    protected abstract M createRequest(String var1);

    protected abstract HttpStatusChecker[] getStatusCheckers();

    protected N getReturnObject(HttpResponse response) throws IOException {
        return null;
    }

    protected void modifyURI(QueryParameters queryParameters) {
        this.request.setURI(URI.create(queryParameters.createUrl(this.request.getURI().toString())));
    }

    protected ObjectMapper createObjectMapper(boolean dealWithRootValue) {
        ObjectMapper objectMapper = new ObjectMapper();
        if (dealWithRootValue) {
            objectMapper.configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, true);
            objectMapper.configure(DeserializationConfig.Feature.UNWRAP_ROOT_VALUE, true);
            objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        }
        return objectMapper;
    }
}

