/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.command.impl.object;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusChecker;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusFailCondition;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusMatch;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusSuccessCondition;
import org.javaswift.joss.command.impl.object.AbstractObjectCommand;
import org.javaswift.joss.command.shared.object.UploadObjectCommand;
import org.javaswift.joss.exception.CommandException;
import org.javaswift.joss.headers.Header;
import org.javaswift.joss.instructions.UploadInstructions;
import org.javaswift.joss.model.Access;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.StoredObject;

public class UploadObjectCommandImpl
extends AbstractObjectCommand<HttpPut, Object>
implements UploadObjectCommand {
    public UploadObjectCommandImpl(Account account, HttpClient httpClient, Access access, StoredObject target, UploadInstructions uploadInstructions) {
        super(account, httpClient, access, target);
        try {
            this.prepareUpload(uploadInstructions);
        }
        catch (IOException err) {
            throw new CommandException("Unable to open input stream for uploading", err);
        }
    }

    protected void prepareUpload(UploadInstructions uploadInstructions) throws IOException {
        HttpEntity entity = uploadInstructions.getEntity();
        this.setHeader(uploadInstructions.getDeleteAt());
        this.setHeader(uploadInstructions.getDeleteAfter());
        this.setHeader(uploadInstructions.getObjectManifest());
        this.setHeader(uploadInstructions.getEtag());
        this.setHeader(uploadInstructions.getContentType());
        if (uploadInstructions.getHeaders() != null) {
            for (Header header : uploadInstructions.getHeaders().values()) {
                this.setHeader(header);
            }
        }
        ((HttpPut)this.request).setEntity(entity);
    }

    @Override
    protected HttpPut createRequest(String url) {
        HttpPut putMethod = new HttpPut(url);
        putMethod.getParams().setParameter("http.protocol.expect-continue", (Object)true);
        return putMethod;
    }

    @Override
    public HttpStatusChecker[] getStatusCheckers() {
        return new HttpStatusChecker[]{new HttpStatusSuccessCondition(new HttpStatusMatch(201)), new HttpStatusFailCondition(new HttpStatusMatch(411)), new HttpStatusFailCondition(new HttpStatusMatch(404)), new HttpStatusFailCondition(new HttpStatusMatch(422))};
    }
}

