/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.client.core;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.javaswift.joss.client.core.AbstractObjectStoreEntity;
import org.javaswift.joss.client.core.AccountPaginationMap;
import org.javaswift.joss.client.core.ContainerCache;
import org.javaswift.joss.client.core.ContainerFactory;
import org.javaswift.joss.client.core.ServerTime;
import org.javaswift.joss.command.shared.factory.AccountCommandFactory;
import org.javaswift.joss.command.shared.identity.tenant.Tenants;
import org.javaswift.joss.headers.Metadata;
import org.javaswift.joss.headers.account.AccountMetadata;
import org.javaswift.joss.information.AbstractInformation;
import org.javaswift.joss.information.AccountInformation;
import org.javaswift.joss.instructions.ListInstructions;
import org.javaswift.joss.model.Access;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.Container;
import org.javaswift.joss.model.PaginationMap;
import org.javaswift.joss.model.Website;
import org.javaswift.joss.util.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccount
extends AbstractObjectStoreEntity<AccountInformation>
implements Account {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractAccount.class);
    private static final Integer MAX_PAGE_SIZE = 9999;
    private boolean allowReauthenticate = true;
    private int numberOfCalls = 0;
    private final AccountCommandFactory commandFactory;
    private final ContainerCache<Container> containerCache;
    private final ContainerCache<Website> websiteCache;
    private ServerTime serverTime = new ServerTime(0L);

    public AbstractAccount(AccountCommandFactory commandFactory, ContainerFactory<Container> containerFactory, ContainerFactory<Website> websiteFactory, boolean allowCaching) {
        super(allowCaching);
        this.containerCache = new ContainerCache<Container>(this, containerFactory);
        this.websiteCache = new ContainerCache<Website>(this, websiteFactory);
        this.commandFactory = commandFactory;
        this.info = new AccountInformation();
    }

    @Override
    public Collection<Container> list() {
        return new AccountPaginationMap(this, null, MAX_PAGE_SIZE).listAllItems();
    }

    @Override
    public Collection<Container> list(PaginationMap paginationMap, int page) {
        return this.list(paginationMap.getPrefix(), paginationMap.getMarker(page), paginationMap.getPageSize());
    }

    @Override
    public Collection<Container> list(String prefix, String marker, int pageSize) {
        ListInstructions listInstructions = new ListInstructions().setPrefix(prefix).setMarker(marker).setLimit(pageSize);
        return (Collection)this.commandFactory.createListContainersCommand(this, listInstructions).call();
    }

    @Override
    public PaginationMap getPaginationMap(String prefix, int pageSize) {
        return new AccountPaginationMap(this, prefix, (Integer)pageSize).buildMap();
    }

    @Override
    public PaginationMap getPaginationMap(int pageSize) {
        return this.getPaginationMap(null, pageSize);
    }

    @Override
    public String getHashPassword() {
        return (String)this.getMetadata("Temp-Url-Key");
    }

    @Override
    public AbstractAccount setHashPassword(String hashPassword) {
        LOG.info("JOSS / Setting hash password");
        if (hashPassword != null && !hashPassword.equals(this.getHashPassword())) {
            LOG.info("JOSS / Hash password not yet saved, saving now");
            this.commandFactory.createHashPasswordCommand(this, hashPassword).call();
        }
        this.invalidate();
        return this;
    }

    @Override
    public AbstractAccount setPublicHost(String publicHost) {
        LOG.info("JOSS / Use public host: " + publicHost);
        this.commandFactory.setPublicHost(publicHost);
        return this;
    }

    @Override
    public AbstractAccount setPrivateHost(String privateHost) {
        LOG.info("JOSS / Use private host: " + privateHost);
        this.commandFactory.setPrivateHost(privateHost);
        return this;
    }

    @Override
    public AbstractAccount setAllowReauthenticate(boolean allowReauthenticate) {
        LOG.info("JOSS / Allow reauthentication: " + allowReauthenticate);
        this.allowReauthenticate = allowReauthenticate;
        return this;
    }

    @Override
    public AbstractAccount setAllowContainerCaching(boolean allowContainerCaching) {
        LOG.info("JOSS / Allow Container caching: " + allowContainerCaching);
        this.containerCache.setCacheEnabled(allowContainerCaching);
        this.websiteCache.setCacheEnabled(allowContainerCaching);
        return this;
    }

    @Override
    public boolean isAllowReauthenticate() {
        return this.allowReauthenticate;
    }

    @Override
    public int getCount() {
        this.checkForInfo();
        return ((AccountInformation)this.info).getContainerCount();
    }

    @Override
    public long getBytesUsed() {
        this.checkForInfo();
        return ((AccountInformation)this.info).getBytesUsed();
    }

    @Override
    public int getObjectCount() {
        this.checkForInfo();
        return ((AccountInformation)this.info).getObjectCount();
    }

    @Override
    public long getServerTime() {
        this.checkForInfo();
        return ((AccountInformation)this.info).getServerDate();
    }

    @Override
    public long getActualServerTimeInSeconds(long seconds) {
        return this.serverTime.getServerTime(seconds);
    }

    @Override
    public void synchronizeWithServerTime() {
        this.serverTime = ServerTime.create(this.getServerTime(), LocalTime.currentTime());
    }

    @Override
    protected Metadata createMetadataEntry(String name, String value) {
        return new AccountMetadata(name, value);
    }

    @Override
    public int getMaxPageSize() {
        return MAX_PAGE_SIZE;
    }

    @Override
    public void increaseCallCounter() {
        ++this.numberOfCalls;
    }

    @Override
    public int getNumberOfCalls() {
        return this.numberOfCalls;
    }

    public AccountCommandFactory getFactory() {
        return this.commandFactory;
    }

    @Override
    public Access authenticate() {
        return this.commandFactory.authenticate();
    }

    @Override
    public Access getAccess() {
        return this.commandFactory.getAccess();
    }

    @Override
    public String getPublicURL() {
        return this.commandFactory.getPublicHost();
    }

    @Override
    public String getPrivateURL() {
        return this.commandFactory.getPrivateHost();
    }

    @Override
    protected void saveSpecificMetadata() {
        this.commandFactory.createAccountMetadataCommand(this, ((AccountInformation)this.info).getMetadata()).call();
    }

    @Override
    protected void getInfo(boolean allowErrorLog) {
        this.info = (AbstractInformation)this.commandFactory.createAccountInformationCommand(this).call();
        this.setInfoRetrieved();
    }

    @Override
    public Tenants getTenants() {
        return (Tenants)this.commandFactory.createTenantCommand(this).call();
    }

    @Override
    public boolean isTenantSupplied() {
        return this.commandFactory.isTenantSupplied();
    }

    @Override
    public String getPathForEntity() throws UnsupportedEncodingException {
        return "";
    }

    @Override
    public Container getContainer(String containerName) {
        return this.containerCache.getContainer(containerName);
    }

    @Override
    public Website getWebsite(String containerName) {
        return this.websiteCache.getContainer(containerName);
    }

    @Override
    public void resetContainerCache() {
        this.containerCache.reset();
    }

    @Override
    public String getOriginalHost() {
        return this.commandFactory.getOriginalHost();
    }
}

