/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.client.core;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.javaswift.joss.client.core.AbstractContainer;
import org.javaswift.joss.client.core.AbstractObjectStoreEntity;
import org.javaswift.joss.client.core.TempURL;
import org.javaswift.joss.command.shared.factory.StoredObjectCommandFactory;
import org.javaswift.joss.exception.CommandException;
import org.javaswift.joss.headers.Metadata;
import org.javaswift.joss.headers.object.DeleteAfter;
import org.javaswift.joss.headers.object.DeleteAt;
import org.javaswift.joss.headers.object.Etag;
import org.javaswift.joss.headers.object.ObjectContentLength;
import org.javaswift.joss.headers.object.ObjectContentType;
import org.javaswift.joss.headers.object.ObjectLastModified;
import org.javaswift.joss.headers.object.ObjectManifest;
import org.javaswift.joss.headers.object.ObjectMetadata;
import org.javaswift.joss.information.AbstractInformation;
import org.javaswift.joss.information.ObjectInformation;
import org.javaswift.joss.instructions.DownloadInstructions;
import org.javaswift.joss.instructions.UploadInstructions;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.Container;
import org.javaswift.joss.model.Directory;
import org.javaswift.joss.model.DirectoryOrObject;
import org.javaswift.joss.model.StoredObject;
import org.javaswift.joss.util.SpaceURLEncoder;

public abstract class AbstractStoredObject
extends AbstractObjectStoreEntity<ObjectInformation>
implements StoredObject {
    protected String name;
    private String bareName;
    private Container container;
    private final StoredObjectCommandFactory commandFactory;

    public AbstractStoredObject(Container container, String name, boolean allowCaching) {
        super(allowCaching);
        this.commandFactory = ((AbstractContainer)container).getFactory().getStoredObjectCommandFactory();
        this.container = container;
        this.name = name;
        this.bareName = Directory.bareName(name, this.commandFactory.getDelimiter());
        this.info = new ObjectInformation();
    }

    @Override
    public void metadataSetFromHeaders() {
        this.staleHeaders = false;
    }

    @Override
    public Date getLastModifiedAsDate() {
        this.checkForInfoAndAllowHeaderSet();
        return ((ObjectInformation)this.info).getLastModifiedAsDate();
    }

    @Override
    public String getLastModified() {
        this.checkForInfoAndAllowHeaderSet();
        return ((ObjectInformation)this.info).getLastModified();
    }

    @Override
    public String getEtag() {
        this.checkForInfoAndAllowHeaderSet();
        return ((ObjectInformation)this.info).getEtag();
    }

    @Override
    public String getManifest() {
        this.checkForInfoAndAllowHeaderSet();
        return ((ObjectInformation)this.info).getManifest();
    }

    @Override
    public long getContentLength() {
        this.checkForInfoAndAllowHeaderSet();
        return ((ObjectInformation)this.info).getContentLength();
    }

    @Override
    public String getContentType() {
        this.checkForInfoAndAllowHeaderSet();
        return ((ObjectInformation)this.info).getContentType();
    }

    @Override
    public Date getDeleteAtAsDate() {
        this.checkForInfo();
        return ((ObjectInformation)this.info).getDeleteAt() == null ? null : ((ObjectInformation)this.info).getDeleteAt().getDate();
    }

    @Override
    public String getDeleteAt() {
        this.checkForInfo();
        return ((ObjectInformation)this.info).getDeleteAt() == null ? null : ((ObjectInformation)this.info).getDeleteAt().getHeaderValue();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Container getContainer() {
        return this.container;
    }

    @Override
    public String getURL() {
        return this.getContainer().isPublic() ? this.getPublicURL() : this.getPrivateURL();
    }

    @Override
    public String getPublicURL() {
        return this.getContainer().getAccount().getPublicURL() + this.getPath();
    }

    @Override
    public String getPrivateURL() {
        return this.getContainer().getAccount().getPrivateURL() + this.getPath();
    }

    @Override
    public String getPathForEntity() throws UnsupportedEncodingException {
        return this.getContainer().getPath() + "/" + SpaceURLEncoder.encode(this.getName());
    }

    @Override
    public void setLastModified(Date date) {
        ((ObjectInformation)this.info).setLastModified(new ObjectLastModified(date));
    }

    @Override
    public void setLastModified(String date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.setLastModified(formatter.parse(date));
        }
        catch (ParseException e) {
            throw new CommandException("Unable to convert date string: " + date, e);
        }
    }

    @Override
    public void setEtag(String etag) {
        ((ObjectInformation)this.info).setEtag(new Etag(etag));
    }

    @Override
    public void setContentLength(long contentLength) {
        ((ObjectInformation)this.info).setContentLength(new ObjectContentLength(Long.toString(contentLength)));
    }

    @Override
    public void setContentTypeWithoutSaving(String contentType) {
        ((ObjectInformation)this.info).setContentType(new ObjectContentType(contentType));
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public void uploadObject(UploadInstructions uploadInstructions) {
        if (uploadInstructions.requiresSegmentation()) {
            this.uploadObjectAsSegments(uploadInstructions);
        } else {
            this.directlyUploadObject(uploadInstructions);
        }
        this.invalidate();
    }

    public void uploadObjectAsSegments(UploadInstructions uploadInstructions) {
        ((AbstractContainer)this.getContainer()).uploadSegmentedObjects(this.getName(), uploadInstructions);
        UploadInstructions manifest = new UploadInstructions(new byte[0]).setObjectManifest(new ObjectManifest(this.getPath().replaceFirst("/", ""))).setContentType(uploadInstructions.getContentType());
        this.uploadObject(manifest);
    }

    public boolean equals(Object o) {
        return o instanceof StoredObject && this.compareTo((StoredObject)o) == 0;
    }

    @Override
    public int compareTo(DirectoryOrObject o) {
        int compareValue = this.getName().compareTo(o.getName());
        if (compareValue == 0 && o instanceof StoredObject) {
            compareValue = this.getContainer().compareTo(((AbstractStoredObject)o).getContainer());
        }
        return compareValue;
    }

    @Override
    protected Metadata createMetadataEntry(String name, String value) {
        return new ObjectMetadata(name, value);
    }

    @Override
    public InputStream downloadObjectAsInputStream() {
        return this.downloadObjectAsInputStream(new DownloadInstructions());
    }

    @Override
    public InputStream downloadObjectAsInputStream(DownloadInstructions downloadInstructions) {
        return (InputStream)this.commandFactory.createDownloadObjectAsInputStreamCommand(this.getAccount(), this.getContainer(), this, downloadInstructions).call();
    }

    @Override
    public byte[] downloadObject() {
        return this.downloadObject(new DownloadInstructions());
    }

    @Override
    public byte[] downloadObject(DownloadInstructions downloadInstructions) {
        return (byte[])this.commandFactory.createDownloadObjectAsByteArrayCommand(this.getAccount(), this.getContainer(), this, downloadInstructions).call();
    }

    @Override
    public void downloadObject(File targetFile) {
        this.downloadObject(targetFile, new DownloadInstructions());
    }

    @Override
    public void downloadObject(File targetFile, DownloadInstructions downloadInstructions) {
        this.commandFactory.createDownloadObjectToFileCommand(this.getAccount(), this.getContainer(), this, downloadInstructions, targetFile).call();
    }

    public void directlyUploadObject(UploadInstructions uploadInstructions) {
        this.commandFactory.createUploadObjectCommand(this.getAccount(), this.getContainer(), this, uploadInstructions).call();
    }

    @Override
    public void uploadObject(InputStream inputStream) {
        this.uploadObject(new UploadInstructions(inputStream));
    }

    @Override
    public void uploadObject(byte[] fileToUpload) {
        this.uploadObject(new UploadInstructions(fileToUpload));
    }

    @Override
    public void uploadObject(File fileToUpload) {
        this.uploadObject(new UploadInstructions(fileToUpload));
    }

    @Override
    public void delete() {
        this.commandFactory.createDeleteObjectCommand(this.getAccount(), this.getContainer(), this).call();
    }

    @Override
    public void copyObject(Container targetContainer, StoredObject targetObject) {
        this.commandFactory.createCopyObjectCommand(this.getAccount(), this.getContainer(), this, ((AbstractStoredObject)targetObject).getContainer(), targetObject).call();
    }

    @Override
    public StoredObject setContentType(String contentType) {
        this.checkForInfo();
        ((ObjectInformation)this.info).setContentType(new ObjectContentType(contentType));
        this.commandFactory.createObjectMetadataCommand(this.getAccount(), this.getContainer(), this, ((ObjectInformation)this.info).getHeadersIncludingHeader(((ObjectInformation)this.info).getContentTypeHeader())).call();
        return this;
    }

    @Override
    public StoredObject setDeleteAfter(Long seconds) {
        this.checkForInfo();
        ((ObjectInformation)this.info).setDeleteAt(null);
        ((ObjectInformation)this.info).setDeleteAfter(seconds == null ? null : new DeleteAfter(seconds));
        this.commandFactory.createObjectMetadataCommand(this.getAccount(), this.getContainer(), this, ((ObjectInformation)this.info).getHeadersIncludingHeader(((ObjectInformation)this.info).getDeleteAfter())).call();
        return this;
    }

    @Override
    public StoredObject setDeleteAfter(long seconds) {
        return this.setDeleteAfter(new Long(seconds));
    }

    @Override
    public StoredObject setDeleteAt(Date date) {
        this.checkForInfo();
        ((ObjectInformation)this.info).setDeleteAt(date == null ? null : new DeleteAt(date));
        this.saveSpecificMetadata();
        return this;
    }

    protected Account getAccount() {
        return this.getContainer().getAccount();
    }

    @Override
    protected void saveSpecificMetadata() {
        this.commandFactory.createObjectMetadataCommand(this.getAccount(), this.getContainer(), this, ((ObjectInformation)this.info).getHeaders()).call();
    }

    @Override
    protected void getInfo(boolean allowErrorLog) {
        this.info = (AbstractInformation)this.commandFactory.createObjectInformationCommand(this.getAccount(), this.getContainer(), this, allowErrorLog).call();
        this.setInfoRetrieved();
    }

    @Override
    public String getTempGetUrl(long durationInSeconds) {
        return this.getTempUrl("GET", durationInSeconds);
    }

    @Override
    public String getTempPutUrl(long durationInSeconds) {
        return this.getTempUrl("PUT", durationInSeconds);
    }

    protected String getTempUrl(String method, long durationInSeconds) {
        return new TempURL(method, this.commandFactory.getTempUrlPrefix(), this).setServerTimeExpiry(durationInSeconds).getTempUrl();
    }

    @Override
    public boolean verifyTempUrl(String method, String signature, long expiry) {
        return new TempURL(method, this.commandFactory.getTempUrlPrefix(), this).setFixedExpiry(expiry).verify(signature, expiry);
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public Directory getAsDirectory() {
        throw new UnsupportedOperationException("A StoredObject cannot be cast to a Directory");
    }

    @Override
    public StoredObject getAsObject() {
        return this;
    }

    @Override
    public String getBareName() {
        return this.bareName;
    }
}

