/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.client.core;

import org.javaswift.joss.client.core.AbstractStoredObject;
import org.javaswift.joss.util.HashSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempURL {
    public static final Logger LOG = LoggerFactory.getLogger(TempURL.class);
    private final AbstractStoredObject object;
    private final String prefix;
    private final String method;
    private long expiry;

    public TempURL(String method, String prefix, AbstractStoredObject object) {
        this.method = method;
        this.prefix = prefix;
        this.object = object;
    }

    public TempURL setServerTimeExpiry(long seconds) {
        this.expiry = this.object.getAccount().getActualServerTimeInSeconds(seconds);
        return this;
    }

    public TempURL setFixedExpiry(long seconds) {
        this.expiry = seconds;
        return this;
    }

    protected String getSignaturePlainText() {
        String objectPath = this.prefix + "/" + this.object.getContainer().getName() + "/" + this.object.getName();
        return this.method + "\n" + this.expiry + "\n" + objectPath;
    }

    protected String getSignature() {
        String plainText = this.getSignaturePlainText();
        LOG.debug("Text to hash for the signature (CRLF replaced by readable \\n): " + plainText.replaceAll("\n", "\\n"));
        return HashSignature.getSignature(this.object.getContainer().getAccount().getHashPassword(), plainText);
    }

    public String getTempUrl() {
        return this.object.getPublicURL() + "?temp_url_sig=" + this.getSignature() + "&temp_url_expires=" + this.expiry;
    }

    public boolean verify(String signature, long expiry) {
        if (signature == null || !signature.equals(this.getSignature())) {
            return false;
        }
        return expiry > this.object.getAccount().getActualServerTimeInSeconds(0L);
    }
}

