/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.client.mock;

import org.javaswift.joss.client.core.AbstractClient;
import org.javaswift.joss.client.factory.AccountConfig;
import org.javaswift.joss.client.mock.AccountMock;
import org.javaswift.joss.command.mock.factory.AuthenticationCommandFactoryMock;
import org.javaswift.joss.command.shared.factory.AuthenticationCommandFactory;
import org.javaswift.joss.swift.MockUserStore;
import org.javaswift.joss.swift.Swift;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMock
extends AbstractClient<AccountMock> {
    public static final Logger LOG = LoggerFactory.getLogger(ClientMock.class);
    private MockUserStore users = new MockUserStore();
    private Swift swift;

    public ClientMock(AccountConfig accountConfig) {
        super(accountConfig);
    }

    @Override
    protected AuthenticationCommandFactory createFactory() {
        return new AuthenticationCommandFactoryMock(this.getOrCreateSwift());
    }

    protected Swift getOrCreateSwift() {
        if (this.swift == null) {
            this.swift = new Swift().setAllowObjectDeleter(this.accountConfig.isMockAllowObjectDeleter()).setOnFileObjectStore(this.accountConfig.getMockClasspath(), this.accountConfig.getMockOnFileObjectStore(), this.accountConfig.isMockOnFileObjectStoreIsAbsolutePath()).setUserStore(this.users).setMillisDelay(this.accountConfig.getMockMillisDelay()).setDelimiter(this.accountConfig.getDelimiter()).setTenantSupplied(this.accountConfig.getTenantId(), this.accountConfig.getTenantName());
        }
        return this.swift;
    }

    @Override
    protected void logSettings() {
        LOG.info("JOSS / MOCK mode");
        LOG.info("JOSS / Creating mock account instance");
        LOG.info("JOSS / * Check credentials: " + !this.accountConfig.isMockAllowEveryone());
        LOG.info("JOSS / * Allow objectdeleter: " + this.accountConfig.isMockAllowObjectDeleter());
        LOG.info("JOSS / * On File ObjectStore: " + this.accountConfig.getMockOnFileObjectStore());
        LOG.info("JOSS / * Use milliseconds delay: " + this.accountConfig.getMockMillisDelay());
    }

    @Override
    protected AccountMock createAccount() {
        if (!this.accountConfig.isMockAllowEveryone()) {
            LOG.info("JOSS / Attempting authentication with tenant name: " + this.accountConfig.getTenantName() + ", tenant ID: " + this.accountConfig.getTenantId() + ", username: " + this.accountConfig.getUsername() + ", Auth URL: " + this.accountConfig.getAuthUrl());
            this.factory.createAuthenticationCommand(null, this.accountConfig.getAuthenticationMethod(), null, this.accountConfig.getTenantName(), this.accountConfig.getTenantId(), this.accountConfig.getUsername(), this.accountConfig.getPassword(), this.accountConfig.getAccessProvider()).call();
        }
        return new AccountMock(this.swift);
    }

    public MockUserStore getUsers() {
        return this.swift.getUserStore();
    }

    public void setUsers(MockUserStore users) {
        this.swift.setUserStore(users);
    }
}

