/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.command.impl.identity;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.javaswift.joss.command.impl.core.AbstractCommand;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusChecker;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusRange;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusSuccessCondition;
import org.javaswift.joss.command.shared.identity.AuthenticationCommand;
import org.javaswift.joss.command.shared.identity.access.AccessNoTenant;
import org.javaswift.joss.command.shared.identity.access.AccessTenant;
import org.javaswift.joss.command.shared.identity.authentication.Authentication;
import org.javaswift.joss.exception.CommandException;
import org.javaswift.joss.headers.Accept;
import org.javaswift.joss.model.Access;

public class KeystoneAuthenticationCommandImpl
extends AbstractCommand<HttpPost, Access>
implements AuthenticationCommand {
    private boolean tenantSupplied;
    private String url;

    public KeystoneAuthenticationCommandImpl(HttpClient httpClient, String url, String tenantName, String tenantId, String username, String password) {
        super(httpClient, url);
        this.setAuthenticationHeader(tenantName, tenantId, username, password);
        this.setTenantSupplied(tenantName, tenantId);
        this.setHeader(new Accept("application/json"));
        this.url = url;
    }

    private void setTenantSupplied(String tenantName, String tenantId) {
        this.tenantSupplied = tenantName != null || tenantId != null;
    }

    private boolean isTenantSupplied() {
        return this.tenantSupplied;
    }

    private void setAuthenticationHeader(String tenantName, String tenantId, String username, String password) {
        try {
            Authentication auth = new Authentication(tenantName, tenantId, username, password);
            String jsonString = this.createObjectMapper(true).writeValueAsString((Object)auth);
            StringEntity input = new StringEntity(jsonString);
            input.setContentType("application/json");
            ((HttpPost)this.request).setEntity((HttpEntity)input);
        }
        catch (IOException err) {
            throw new CommandException("Unable to set the JSON body for the authentication header", err);
        }
    }

    @Override
    public Access getReturnObject(HttpResponse response) throws IOException {
        if (this.isTenantSupplied()) {
            return (Access)this.createObjectMapper(true).readValue(response.getEntity().getContent(), AccessTenant.class);
        }
        return (Access)this.createObjectMapper(true).readValue(response.getEntity().getContent(), AccessNoTenant.class);
    }

    @Override
    protected HttpPost createRequest(String url) {
        return new HttpPost(url);
    }

    @Override
    public HttpStatusChecker[] getStatusCheckers() {
        return new HttpStatusChecker[]{new HttpStatusSuccessCondition(new HttpStatusRange(200, 299))};
    }

    @Override
    public String getUrl() {
        return this.url;
    }
}

